<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @package WordPress
 * @subpackage Grevo
 * @since 1.0
 * @version 1.2
 */


$footer_show_social		= thsn_get_base_option('footer-show-social');
$footer_show_menu		= thsn_get_base_option('footer-show-menu');
$footer_widget_columns	= thsn_footer_widget_columns(); // array
$widget_exists			= $footer_widget_columns[0];
$footer_columns			= $footer_widget_columns[1];
$footer_column			= $footer_widget_columns[2];
$footer_boxes_area = thsn_get_base_option('footer-boxes-area');
$footer_style = thsn_get_base_option('footer-style');


// Footer social and menu
$footer_column_class = '';
$social_html = '';
if( $footer_show_social==true ){
	$social_html = do_shortcode('[thsn-social-links]');
}
$menu_html = '';
if( $footer_show_menu==true && has_nav_menu('themesion-footer') ){
	ob_start();
	wp_nav_menu( array(
		'theme_location' => 'themesion-footer',
		'menu_id'        => 'thsn-footer-menu',
		'menu_class'     => 'thsn-footer-menu',
	) );
	$menu_html = ob_get_contents();
	ob_end_clean();
}
?>
     	<?php if( thsn_check_sidebar() == true ){ ?>
					</div><!-- .row -->
				<?php } ?>
				</div><!-- #content -->
			</div><!-- .site-content-wrap -->

			<?php if( $footer_boxes_area == true ) { ?>				
				<div class="thsn-footer-section thsn-footer-big-area-wrapper <?php if( $footer_style == '1' ){ 
    echo "thsn-parent-footer-1"; } elseif ($footer_style == '2'){ echo "thsn-parent-footer-2";} else {  echo "thsn-footer-none";} ?> ">
			<div class="footer-wrap thsn-footer-big-area">
				<div class="container">
					<div class="row">								
						<div class="col-sm-12 d-flex justify-content-between"> 
							<?php thsn_footer_boxes_area(); ?>
						</div>	
					</div>
				</div>
			</div>
		</div>
			<?php } ?>
		<footer id="colophon" class="thsn-footer-section site-footer <?php thsn_footer_classes(); ?>">
		
			<?php if( $widget_exists==true ) : ?>
			<div class="thsn-footer-section footer-wrap thsn-footer-widget-area <?php thsn_footer_widget_classes(); ?>">
				<div class="container">
					<div class="row">
						<?php 
						$col = 1;
						foreach( $footer_columns as $column ){
							$class = ( $footer_column == '3-3-3-3' ) ? 'col-md-6 col-lg-3' : 'col-md-'.$column ;
							if ( is_active_sidebar( 'thsn-footer-'.$col ) ) { ?>
								<div class="thsn-footer-widget thsn-footer-widget-col-<?php echo esc_attr($col); ?> <?php echo esc_attr($class); ?>">
									<?php dynamic_sidebar( 'thsn-footer-'.$col ); ?>
								</div><!-- .thsn-footer-widget -->
							<?php };
							$col++;
						} // end foreach
						?>
					</div><!-- .row -->
				</div>	
			</div>
			<?php endif; ?>
			<div class="thsn-footer-section thsn-footer-text-area <?php thsn_footer_copyright_classes(); ?>">
				<div class="container">
					<div class="thsn-footer-text-inner">
					    <div class="row align-items-center">
						    <?php thsn_footer_copyright_area(); ?>
					    </div>							
				   </div>	
			   </div>
			</div> 
		</footer><!-- #colophon -->
	</div><!-- .site-content-contain -->
</div><!-- #page -->
<a href="#" class="scroll-to-top" title="<?php echo esc_html_e( 'Back to Top', 'grevo' ); ?>"><i class="thsn-base-icon-up-open-big"></i></a>
<?php wp_footer(); ?>
</body>
</html>


