<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Section Heading 
 */
class THSN_TabsElement extends Widget_Base{

 	/**
	 * Get widget name.
	 *
	 * Retrieve tabs widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'thsn_tabs_element';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve tabs widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Grevo Tabs Element', 'grevo' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve tabs widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-box';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'grevo_category' ];
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'tabs', 'accordion', 'toggle' ];
	}

	protected function register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Tabs', 'grevo' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'tab_icon',
			[
				'label' => __( 'Icon', 'grevo' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
			]
		);

		$repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Title & Description', 'grevo' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Tab Title', 'grevo' ),
				'placeholder' => __( 'Tab Title', 'grevo' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'tab_content',
			[
				'label' => __( 'Content', 'grevo' ),
				'default' => __( 'Tab Content', 'grevo' ),
				'placeholder' => __( 'Tab Content', 'grevo' ),
				'type' => Controls_Manager::WYSIWYG,
				'show_label' => false,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => __( 'Tabs Items', 'grevo' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title' => __( 'Tab #1', 'grevo' ),
						'tab_icon' => [ 'value' => 'fas fa-star', 'library' => 'fa-solid' ],
						'tab_content' => __( 'We help ambitious businesses like yours generate more profits by building awareness, driving web traffic, connecting with customers, and growing overall sales. Give us a call.', 'grevo' ),
					],
					[
						'tab_title' => __( 'Tab #2', 'grevo' ),
						'tab_icon' => [ 'value' => 'fas fa-star', 'library' => 'fa-solid' ],
						'tab_content' => __( 'We help ambitious businesses like yours generate more profits by building awareness, driving web traffic, connecting with customers, and growing overall sales. Give us a call.', 'grevo' ),
					],
				],
				'title_field' => '{{{ tab_title }}}',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

		<div class="thsn-tabs">
			<?php if ( $settings['tabs'] ) : ?>
			<ul class="thsn-tabs-heading">
				<?php $i = 1; foreach ( $settings['tabs'] as $tabs ) { ?>
					<?php $active_li_class = ( $i==1 ) ? 'thsn-tab-li-active' : '' ; ?>

					<?php
					// icon
					$icon_html = '';
					if( !empty($tabs['tab_icon']['value']) ){
						$icon_html = '<i class="' . esc_attr($tabs['tab_icon']['value']) . '" aria-hidden="true"></i> ';
						wp_enqueue_style( 'elementor-icons-'.$tabs['tab_icon']['library']);
					}
					?>

				<li class="thsn-tab-link <?php echo esc_attr($active_li_class); ?>" data-thsn-tab="<?php echo esc_attr($i); ?>"><?php echo thsn_esc_kses($icon_html); ?><span><?php echo esc_html($tabs['tab_title']); ?></span></li>
				<?php $i++; } ?>
			</ul>

			<div class="thsn-tab-content-wrapper">
				<?php $j = 1; foreach ( $settings['tabs'] as $tabs ) { ?>
					<?php $active_class = ( $j==1 ) ? 'thsn-tab-active' : '' ; ?>
					<div class="thsn-tab-content thsn-tab-content-<?php echo esc_attr($j); ?> <?php echo esc_attr($active_class); ?>">
						<?php
						$icon_html = ''; // icon
						if( !empty($tabs['tab_icon']['value']) ){
							$icon_html = '<i class="' . esc_attr($tabs['tab_icon']['value']) . '" aria-hidden="true"></i> ';
							wp_enqueue_style( 'elementor-icons-'.$tabs['tab_icon']['library']);
						}
						?>
						<div class="thsn-tab-content-title" data-thsn-tab="<?php echo esc_attr($j); ?>"><?php echo thsn_esc_kses($icon_html); ?><?php echo esc_html($tabs['tab_title']); ?></div>
						<div class="thsn-tab-content-inner">
							<?php echo thsn_esc_kses($tabs['tab_content']); ?>
						</div>
					</div>
				<?php $j++; } ?>
			</div>

			<?php endif; ?>
	    </div>

	    <?php
	}

	protected function content_template() {}
}
// After the Schedule class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new THSN_TabsElement() );