<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Grevo
 * @since 1.0
 * @version 1.0
 */
?>
<?php
$sidebar	= 'thsn-sidebar-post';
$aria_label	= esc_attr__( 'Blog Sidebar', 'grevo' );
if( is_page() ){
	// page sidebar
	$sidebar	= 'thsn-sidebar-page';
	$aria_label	= esc_attr__( 'Page Sidebar', 'grevo' );
	if( function_exists('is_woocommerce') && is_woocommerce() ){
		$sidebar	= 'thsn-sidebar-wc-shop';
		$aria_label	= esc_attr__( 'WooCommerce Sidebar', 'grevo' );
	}
} else if( is_search() ){
	$sidebar	= 'thsn-sidebar-search';
	$aria_label	= esc_attr__( 'Search Results Sidebar', 'grevo' );
} else if( function_exists('is_woocommerce') && is_woocommerce() && !is_product() ){
	$sidebar	= 'thsn-sidebar-wc-shop';
	$aria_label	= esc_attr__( 'WooCommerce Sidebar', 'grevo' );
} else if( function_exists('is_product') && is_product() ){
	$sidebar	= 'thsn-sidebar-wc-single';
	$aria_label	= esc_attr__( 'WooCommerce Sidebar', 'grevo' );
} else if( is_singular('event_listing') ){
	$sidebar		= 'thsn-sidebar-event-single';
	$aria_label		= esc_attr__( 'Single Event Sidebar', 'grevo' );
} else if( is_tax('event_listing_category') || is_tax('event_listing_type') || is_singular( 'event_organizer' ) || is_singular( 'event_venue' ) ){
	$sidebar		= 'thsn-sidebar-event';
	$aria_label		= esc_attr__( 'Event Sidebar', 'grevo' );
} else if( is_singular('thsn-portfolio') ){
	$sidebar		= 'thsn-sidebar-portfolio';
	$aria_label		= esc_attr__( 'Portfolio Sidebar', 'grevo' );
} else if( is_tax('thsn-portfolio-category') || is_post_type_archive('thsn-portfolio') ){
	$sidebar		= 'thsn-sidebar-portfolio-cat';
	$aria_label		= esc_attr__( 'Portfolio Category Sidebar', 'grevo' );
} else if( is_singular('thsn-service') ){
	$sidebar		= 'thsn-sidebar-service';
	$aria_label		= esc_attr__( 'Service Sidebar', 'grevo' );
} else if( is_tax('thsn-service-category') || is_post_type_archive('thsn-service') ){
	$sidebar		= 'thsn-sidebar-service-cat';
	$aria_label		= esc_attr__( 'Service Category Sidebar', 'grevo' );
} else if( is_singular('thsn-team-member') ){
	$sidebar		= 'thsn-sidebar-team';
	$aria_label		= esc_attr__( 'Team Member Sidebar', 'grevo' );
} else if( is_tax('thsn-team-group') || is_post_type_archive('thsn-team-member') ){
	$sidebar		= 'thsn-sidebar-team-group';
	$aria_label		= esc_attr__( 'Team Group Sidebar', 'grevo' );
}

// check if content exists for the sidebar
$sidebar_content = '';
ob_start();
dynamic_sidebar( $sidebar );
$sidebar_content = ob_get_clean();

?>
<?php if ( is_active_sidebar( $sidebar ) && thsn_check_sidebar()==true && !empty($sidebar_content) ) : ?>
<aside id="secondary" class="widget-area themesion-sidebar col-md-3 col-lg-3" aria-label="<?php echo esc_attr( $aria_label ); ?>">
	<?php dynamic_sidebar( $sidebar ); ?>
</aside><!-- #secondary -->
<?php endif; ?>