<?php
$icon_html = '';
$custom_icon_enabled = get_post_meta( get_the_ID(), 'thsn-custom-icon-enabled', true ); 
if( $custom_icon_enabled=='1' ){
	$img_src = '';
	$custom_icon_url = get_post_meta( get_the_ID(), 'thsn-custom-icon', true );
	if( !empty($custom_icon_url) ){
		$img_src = wp_get_attachment_image_src($custom_icon_url, 'full');
		if( !empty($img_src[0]) ){ $custom_icon_url = $img_src[0]; }
	}
	$icon_html = '<img src="'.$custom_icon_url.'"/>';
}else{
	$icon_lib = get_post_meta( get_the_ID(), 'thsn-service-icon-library', true );
	wp_enqueue_style($icon_lib);
	$icon_class = get_post_meta( get_the_ID(), 'thsn-service-icon-'.$icon_lib, true );
	if( !empty($icon_class) ){
		$icon_html = '<i class="'.esc_attr($icon_class).'"></i>';
	}
}

// Read More text
if( !isset($more_text) ){
	$more_text = esc_attr__('Read More','grevo');
}
?>
<div class="themesion-post-item">
	<div class="thsn-service-img-wrapper">			  
		<?php thsn_get_featured_data( array( 'featured_img_only' => true, 'size' => 'thsn-img-770x500' ) ); ?>	
	</div> 
	<div class="themesion-box-content"> 
		<div class="themesion-box-content-inner d-flex justify-content-between">
			<div class="themesion-title-box">
				<div class="thsn-service-cat"><h4><?php echo get_the_term_list( get_the_ID(), 'thsn-service-category', '', ', ' ); ?></h4></div>
				<h3 class="thsn-service-title"><a href="<?php the_permalink(); ?>" title="<?php echo get_the_title(); ?>"><?php echo get_the_title(); ?></a></h3> 
			</div>
			<div class="thsn-service-icon-wrapper">	
				<?php echo thsn_esc_kses($icon_html); ?>
			</div>
		</div>
	</div>
</div>
