<?php
// Getting all options with values
$all_data = thsn_get_all_option_array();

$gradient_first = '#ffff00';
$gradient_last  = '#ffff00';
$responsive_breakpoint	= '1200';
$preheader_responsive	= '1200';
if( function_exists('thsn_get_base_option') ){
	$gradient_colors = thsn_get_base_option('gradient-color');
	$gradient_first  = ( !empty($gradient_colors['first']) ) ? $gradient_colors['first'] : '#ffff00' ;
	$gradient_last   = ( !empty($gradient_colors['last'])  ) ? $gradient_colors['last']  : '#ffff00' ;

	$responsive_breakpoint	= thsn_get_base_option('responsive-breakpoint');
	$preheader_responsive	= thsn_get_base_option('preheader-responsive');
	$service_single_image_hide = thsn_get_base_option('service-single-image-hide');
}

// new code start here
$new_all_data = array();
foreach( $all_data as $key=>$val ){
	$key            = str_replace( '_', '-', $key );
	$key            = str_replace( '_', '-', $key );
	$key            = str_replace( '_', '-', $key );
	$key            = str_replace( '_', '-', $key );
	$key            = str_replace( '_', '-', $key );
	$new_all_data[$key] = $val;
}

// allowed to create css variables
$allowed = array(
	'global-color',
	'secondary-color',
	'gradient-color',
	'white-color',
	'blackish-color',
	'light-bg-color',
	'blackish-bg-color',
	'header-height',
	'sticky-header-height',
	'responsive-breakpoint',
	'main-menu-typography',
	'main-menu-sticky-color',
	'main-menu-sticky-active-color',
	'preheader-bgcolor-custom',
	'header-background-color',
	'menu-background-color',
	'sticky-header-background-color',
	'link-color',
	'header-height',
	'logo-height',
	'responsive-logo-height',
	'titlebar-height',
	'sticky-logo-height',
	'light-bg-color',
	'footer-1-col-width',
	'footer-2-col-width',
	'footer-3-col-width',
	'footer-4-col-width',
);
?>

:root {
<?php
foreach( $new_all_data as $key=>$val ){

	if( in_array( $key, array( 'sticky-logo-height', 'responsive-logo-height', 'header-height', 'sticky-header-height', 'logo-height', 'responsive-logo-height', 'responsive-breakpoint', 'titlebar-height' ) ) ){
		$val .= 'px';
	}
	if( in_array( $key, array( 'footer-1-col-width', 'footer-2-col-width', 'footer-3-col-width', 'footer-4-col-width' ) ) ){
		$val .= '%';
	}

	if( in_array( $key, $allowed ) ){
		if( is_array($val) ){
			foreach( $val as $val_key=>$val_val ){
				if( !empty($val_val) ){
				?>
	--thsn-grevo-<?php echo esc_attr($key); ?>-<?php echo esc_attr($val_key); ?>: <?php echo esc_attr($val_val); ?>;
<?php
				}
			}
		} else {
		?>
	--thsn-grevo-<?php echo esc_attr($key); ?>: <?php echo esc_attr($val) ?>;
<?php

		}
	}
}

// value is color for the option
$colors = array(
	'global-color',
	'secondary-color',
	'white-color',
	'blackish-color',
	'light-bg-color',
	'blackish-bg-color',
	'main-menu-typography',
);

foreach( $new_all_data as $key=>$val ){
	if( in_array( $key, $colors ) ){
		if( is_array($val) && isset($val['color']) ){
			$key .= '-color';
			$val = $val['color'];
		}
		?>
	--thsn-grevo-<?php echo esc_attr($key); ?>-rgb: <?php echo esc_attr( thsn_hex2rgb_code($val) ) ?>;
<?php
	}
}
?>

} /* CSS :root ends here */

<?php echo thsn_all_options_values('background'); ?>
<?php echo thsn_all_options_values('typography'); ?>

/* --------------------------------------
 * Common header bg
 * ---------------------------------------*/

.site-header .thsn-sticky-header.thsn-sticky-bg-color-globalcolor{
	background-color: var(--thsn-grevo-global-color);
}
.site-header .thsn-sticky-header.thsn-sticky-bg-color-secondarycolor{
	background-color: var(--thsn-grevo-secondary-color);
}
.site-header .thsn-sticky-header.thsn-sticky-bg-color-blackish{
	background-color: var(--thsn-grevo-blackish-bg-color);
}
.site-header .thsn-sticky-header.thsn-sticky-bg-color-white{
	background-color: var(--thsn-grevo-white-color);
}
.site-header .thsn-sticky-header.thsn-sticky-bg-color-light{
	background-color: var(--thsn-grevo-light-bg-color);
}

/* --------------------------------------
 * Custom background color and text color
 * ---------------------------------------*/
/* Custom preheader background color */
.thsn-pre-header-wrapper.thsn-bg-color-custom{
	background-color: var(--thsn-grevo-preheader-bgcolor-custom);
}
/* Custom Header background color */
.thsn-header-wrapper.thsn-bg-color-custom{
	background-color: var(--thsn-grevo-header-background-color);
}
/* Custom Menu area background color */
.thsn-header-menu-area.thsn-bg-color-custom{
	background-color: var(--thsn-grevo-menu-background-color);
}
/* sticky-header-background-color */
.site-header.thsn-fixed-header .thsn-sticky-bg-color-custom{
	background-color: var(--thsn-grevo-sticky-header-background-color);
}
/* Custom Menu text color */
body:not(.thsn-max-mega-menu-override) .thsn-sticky-header .thsn-navbar div > ul > li > a{
	color: var(--thsn-grevo-main-menu-sticky-color);
}
/* Main Sticky Menu active text color */
body:not(.thsn-max-mega-menu-override) .thsn-sticky-header .thsn-navbar div > ul > li.current_page_item > a,
body:not(.thsn-max-mega-menu-override) .thsn-sticky-header .thsn-navbar.thsn-main-active-color-globalcolor > div > ul >li.current-menu-parent > a {
	color: var(--thsn-grevo-main-menu-sticky-active-color);
}
<?php if($service_single_image_hide==true){ ?>
/* Hide single image in service */

.single.single-thsn-service .thsn-service-single .thsn-service-feature-image img {
	display: none;
}

<?php } ?>

/* --------------------------------------
 * A tag
 * ---------------------------------------*/
a{
	color: var(--thsn-grevo-link-color-normal);
}
a:hover{
	color: var(--thsn-grevo-link-color-hover);
}

/* --------------------------------------
 * site-title
 * ---------------------------------------*/
.site-title {
	height: var(--thsn-grevo-header-height);
}
.site-title img.thsn-main-logo{
	max-height: var(--thsn-grevo-logo-height);
}
.site-title img.thsn-responsive-logo{
	max-height: var(--thsn-grevo-responsive-logo-height);
}

/*=== Sticky logo ===*/
.site-header.thsn-fixed-header .site-title img.thsn-main-logo{
	max-height: var(--thsn-grevo-sticky-logo-height);
}

/* --------------------------------------
 * Global color
 * ---------------------------------------*/
.thsn-color-globalcolor,
.thsn-globalcolor,
.globalcolor{
	color: var(--thsn-grevo-global-color) ;
}

/* --------------------------------------
 * Global Color
 * ---------------------------------------*/
/*=== Global BG Color ===*/
.site-header .thsn-sticky-on.thsn-sticky-bg-color-globalcolor,
.site-header .thsn-bg-color-globalcolor,
.thsn-bg-color-globalcolor{
    background-color: var(--thsn-grevo-global-color);
}

/*=== Global Text Color ===*/
.thsn-globalcolor,
.thsn-skincolor{
   	color: var(--thsn-grevo-global-color);
}

/*=== Global Border Color ===*/

input[type="text"]:focus, 
input[type="email"]:focus, 
input[type="tel"]:focus, 
textarea:focus,
.post.sticky{
	border-color: var(--thsn-grevo-global-color);
}

/* --------------------------------------
 * Secondary Color
 * ---------------------------------------*/

/*=== Secondary BG Color ===*/
.thsn-bg-color-secondarycolor,
.thsn-bg-color-secondary{
	background-color: var(--thsn-grevo-secondary-color);   
}

/* --------------------------------------
 *  Gradient Color
 * ---------------------------------------*/

/*=== Gradient BG Color ===*/
.elementor-widget-button.thsn-btn-color-gradient .elementor-button,
.thsn-bg-color-gradient{
	background-image: -ms-linear-gradient(right, var(--thsn-grevo-gradient-color-first) 0%, var(--thsn-grevo-gradient-color-last) 100%);
	background-image: linear-gradient(to right, var(--thsn-grevo-gradient-color-first) , var(--thsn-grevo-gradient-color-last) );
}
.thsn-footer-section.thsn-bg-color-gradientcolor:before{
	background-image: -ms-linear-gradient(right, var(--thsn-grevo-gradient-color-first) 0%, var(--thsn-grevo-gradient-color-last) 100%) !important;
	background-image: linear-gradient(to right, var(--thsn-grevo-gradient-color-first) , var(--thsn-grevo-gradient-color-last) ) !important;
}
.elementor-widget-button.thsn-btn-color-gradient .elementor-button {	
	border-image-slice: 1;
	border-image-source: linear-gradient(to left, var(--thsn-grevo-gradient-color-first), var(--thsn-grevo-gradient-color-last));
}

/* --------------------------------------
 *  Light Color
 * ---------------------------------------*/
.thsn-btn-style-flat.thsn-btn-color-light .elementor-button,
.thsn-bg-color-light{
    background-color: var(--thsn-grevo-light-bg-color);
}

.thsn-btn-style-text.thsn-btn-color-light .elementor-button{
	color: var(--thsn-grevo-light-bg-color);
}
.thsn-btn-style-outline.thsn-btn-color-light .elementor-button{
	border-color: var(--thsn-grevo-light-bg-color);
	color: var(--thsn-grevo-light-bg-color);
}

/* --------------------------------------
 * White color
 * ---------------------------------------*/
 .thsn-elementor-bg-color-globalcolor .thsn-btn-color-blackish .elementor-button:hover{
 	background-color:#fff;
}

/* --------------------------------------
 * Woocommerce
 * ---------------------------------------*/
.thsn-cart-wrapper.thsn-show-cart-amount-no .woocommerce-Price-amount.amount{
	display: none !important;
}

/* --------------------------------------
 * thsn-responsive-icons
 * ---------------------------------------*/
 .thsn-responsive-icons{
	position: absolute;
	top: 30px;
	left: 20px;
	display: none;
}
.thsn-responsive-icons .thsn-header-search-btn {
    font-size: 18px;
    position: relative;
    top: 0;
    line-height: normal;
}
.admin-bar .thsn-responsive-icons{
	top: 75px;
}
.thsn-responsive-icons > div{
	margin: 0 10px;
}
.thsn-responsive-icons > div:first-child{
	margin-left: 0;
}
.thsn-responsive-icons .thsn-cart-wrapper a {
	position: relative;
	padding-left: 30px;
	color: var(--thsn-grevo-blackish-color);
}
.thsn-responsive-icons .thsn-cart-wrapper.thsn-show-cart-amount-no a {
	padding-left: 25px;
}
.thsn-responsive-icons .thsn-cart-wrapper a:before {
	content: "\e83b";
	font-family: "themesion-base-icons";
	font-size: 20px;
	line-height: 20px;
	position: absolute;
	left: 0;
	top: 50%;
	-webkit-transform: translateY(-50%);
	-ms-transform: translateY(-50%);
	-moz-transform: translateY(-50%);
	transform: translateY(-50%);
	font-weight: 400;
	-webkit-transition: all .25s ease-in-out;
	transition: all .25s ease-in-out;
}
.thsn-responsive-icons .thsn-cart-wrapper .thsn-cart-count {
	position: absolute;
	top: -21px;
	left: 2px;
	background-color: var(--thsn-grevo-global-color);
	color: var(--thsn-grevo-white-color);
	line-height: 20px;
	width: 20px;
	text-align: center;
	border-radius: 50%;
	font-size: 13px;
}

/*====================================  End Dynamic color  ====================================*/

/* * * * *  MENU AND BREAKPOINT CSS  * * * * * */
/*====================================  Max Width for dynamic breakpoint  ====================================*/
@media (max-width: <?php echo esc_attr($responsive_breakpoint); ?>px){

	.thsn-header-top-area > .container{
		position: relative;
	}
	.site-header .thsn-sticky-header {
		display: none !important;
	}
	.thsn-header-info-inner,
	.something{
		display: none;
	}
	.navbar-expand-lg .navbar-nav{
		-ms-flex-direction: unset !important;
		flex-direction: unset !important;
	}
	.thsn-header-menu-area-inner,
	.thsn-navbar{
	    display: block !important;
	}
	.nav-menu-toggle{
	    display: block;
	    position: absolute;
	    right: 0px;
	    top: 50%;
	    -webkit-transform: translateY(-50%);
	    -ms-transform: translateY(-50%);
	    transform: translateY(-50%);
	    background-color: transparent;
	    padding: 0;
	    font-size: 35px;
	    line-height: 35px;
	    color: #2c2c2c;
	    width: 40px;
	}
	.thsn-navbar > div{
		background-color: #fff;
	}
	.sub-menu{
		display: none;
	}
	.thsn-header-menu-area-wrapper{
		min-height: auto !important;
	}
	.closepanel{
		position: absolute;
		z-index: 99;
		right: 35px;
		top: 35px;
		display: block;
		width: 30px;
		height: 30px;
		line-height: 30px;		
		border-radius: 50%;
		text-align: center;
		cursor: pointer;
		font-size: 35px;
	}
	.admin-bar .closepanel{
		top: 70px;
	}
	.closepanel {
		position: absolute;
		z-index: 99;
		right: 20px;
		margin-left: -20px;
		top: 30px;
		display: block;
		width: 30px;
		height: 30px;
		line-height: 30px;
		border-radius: 50%;
		text-align: center;
		cursor: pointer;
		font-size: 25px;
		color: var(--thsn-grevo-blackish-color);
		border: 0;
		-webkit-transition: all 300ms ease;
		transition: all 300ms ease;
	}

	/*=== Responsive menu ===*/
	.thsn-responsive-icons{
		display: flex;
	}

	.active .thsn-mobile-menu-bg{
		opacity: 1;
		width: 100%;
		visibility: visible;
		transition: all 900ms ease;
		-moz-transition: all 900ms ease;
		-webkit-transition: all 900ms ease;
		-ms-transition: all 900ms ease;
		-o-transition: all 900ms ease;
		-webkit-transform: translateX(0%);
		-ms-transform: translateX(0%);
		transform: translateX(0%);
	}

	/*=== Responsive menu ===*/
	.thsn-mobile-menu-bg{
		display: block;
	}
	.thsn-mobile-menu-bg{
		position: fixed;
		right: 0;
		top: 0;
		width: 0%;
		height: 100%;
		z-index: 99;
		background: rgba(0,0,0,0.90);
		-webkit-transform: translateX(101%);
		-ms-transform: translateX(101%);
		transform: translateX(101%);
		transition: all 900ms ease;
		-moz-transition: all 900ms ease;
		-webkit-transition: all 900ms ease;
		-ms-transition: all 900ms ease;
		-o-transition: all 900ms ease;
		-webkit-transition-delay: 300ms;
		-moz-transition-delay: 300ms;
		-ms-transition-delay: 300ms;
		-o-transition-delay: 300ms;
		transition-delay: 300ms;
	}
	.active .thsn-mobile-menu-bg{
		opacity: 1;
		width: 100%;
		visibility: visible;
		transition: all 900ms ease;
		-moz-transition: all 900ms ease;
		-webkit-transition: all 900ms ease;
		-ms-transition: all 900ms ease;
		-o-transition: all 900ms ease;
		-webkit-transform: translateX(0%);
		-ms-transform: translateX(0%);
		transform: translateX(0%);
	}
	.thsn-navbar > div {
	    background-color: #fff;
	    position: fixed;
		top: 0;
		right: -400px;
	    z-index: 1000;
	    width: 300px;
	    height: 100%;
	    padding: 0;
	    display: block;	    
		transition: all 900ms ease;
		-moz-transition: all 900ms ease;
		-webkit-transition: all 900ms ease;
		-ms-transition: all 900ms ease;
		-o-transition: all 900ms ease;
	    -webkit-transform: translateX(400px);
	    -ms-transform: translateX(400px);
	    transform: translateX(400px);
		opacity: 0;
	}
	.thsn-navbar > div.active {
		right: 0px;
	    -webkit-transform: translateX(0);
	    -ms-transform: translateX(0);
	    transform: translateX(0);
	    visibility: visible;
	    opacity: 1;
		overflow-y: scroll;
		-webkit-transition-delay: 600ms;
		-moz-transition-delay: 600ms;
		-ms-transition-delay: 600ms;
		-o-transition-delay: 600ms;
		transition-delay: 600ms;
		opacity: 1;
	}
	.thsn-navbar > div > ul{
		padding: 90px 0;
	}
	.admin-bar .thsn-navbar > div > ul{
		padding-top: 125px;
	}
	.thsn-navbar > div > ul li a {
	    color: #000 !important;
	    padding: 15px 25px;
	    height: auto;
	    display: inline-block;
	}
	.thsn-navbar > div > ul ul {
	    padding-left: 1em;
	    overflow: hidden;
	    display: none;
	}
	ul .sub-menu.show,
	ul .children.show {
	    display: block;
	}
	.thsn-navbar li{
		position: relative;
	}
	.thsn-navbar ul.menu > li{
		border-bottom: 1px solid rgba(0, 0, 0, 0.10);
	}
	.thsn-navbar div.menu > ul > li, 
	.thsn-navbar ul.menu > li {
		border-bottom: 1px solid rgba(0, 0, 0, 0.10);
	}
	.sub-menu-toggle{
	    display: block;
	    position: absolute;
	    right: 25px;
	    top: 15px;
	    cursor: pointer;
	    color: var(--thsn-grevo-blackish-color);
	}
	.thsn-navbar ul ul{
		background-color: transparent !important;
	}
	.thsn-mobile-search{
		display: block;
	}
	.thsn-mobile-search .thsn-header-search-btn{
		display: block;
		position: absolute;
		right: 60px;
		top: 50%;
		-webkit-transform: translateY(-50%);
		-ms-transform: translateY(-50%);
		transform: translateY(-50%);
	}

	/*=== Responsive Logo ===*/
	.thsn-responsive-logo-yes .thsn-sticky-logo,
	.thsn-responsive-logo-yes .thsn-main-logo{
		display: none;
	}
	.thsn-responsive-logo-yes .thsn-responsive-logo{
		display: inline-block;
	}

	/*=== Responsive header background color ===*/
	.thsn-responsive-header-bgcolor-globalcolor .thsn-header-wrapper{
		background-color: var(--thsn-grevo-global-color) !important;
	}
	.thsn-responsive-header-bgcolor-white .thsn-header-wrapper{
		background-color: #fff !important;
	}
	.thsn-responsive-header-bgcolor-blackish .thsn-header-wrapper{
		background-color: #222 !important;
	}
}
/*====================================  End Max Break Point  ====================================*/
/*====================================  Min Width for dynamic breakpoint  ====================================*/

@media (min-width: <?php echo esc_attr($responsive_breakpoint+1); ?>px){
	.site-header .thsn-sticky-header {
		position: fixed;
		opacity: 0;
		visibility: hidden;
		background: #fff;
		left: 0px;
		top: 0px;
		box-shadow: 0 10px 20px rgb(0 0 0 / 20%);
		width: 100%;
		z-index: 0;
		transition: all 200ms ease;
		-moz-transition: all 200ms ease;
		-webkit-transition: all 200ms ease;
		-ms-transition: all 200ms ease;
		-o-transition: all 200ms ease;
	}
	.site-header.thsn-fixed-header .thsn-sticky-header {
		z-index: 999;
		opacity: 1;
		visibility: visible;
		-ms-animation-name: fadeInDown;
		-moz-animation-name: fadeInDown;
		-op-animation-name: fadeInDown;
		-webkit-animation-name: fadeInDown;
		animation-name: fadeInDown;
		-ms-animation-duration: 300ms;
		-moz-animation-duration: 300ms;
		-op-animation-duration: 300ms;
		-webkit-animation-duration: 300ms;
		animation-duration: 300ms;
		-ms-animation-timing-function: linear;
		-moz-animation-timing-function: linear;
		-op-animation-timing-function: linear;
		-webkit-animation-timing-function: linear;
		animation-timing-function: linear;
		-ms-animation-iteration-count: 1;
		-moz-animation-iteration-count: 1;
		-op-animation-iteration-count: 1;
		-webkit-animation-iteration-count: 1;
		animation-iteration-count: 1;
	}	
	.admin-bar .site-header .thsn-sticky-header {
		top: 32px;
	}
	.thsn-responsive-logo{
		display: none;
	}
	.nav-menu-toggle,
	.something{
		display: none;
	}
	.thsn-sticky-on .site-title img.thsn-main-logo,
	.site-title img.thsn-sticky-logo{
		max-height: var(--thsn-grevo-sticky-logo-height);
	}
	body .thsn-navbar > div > ul > li,
	body .thsn-navbar > div > ul > li > a{
	    line-height: var(--thsn-grevo-header-height) !important;
	    height: var(--thsn-grevo-header-height) !important;
	}
	.thsn-sticky-header .thsn-navbar > div > ul > li,
	.thsn-sticky-header .thsn-navbar > div > ul > li > a,
	.thsn-sticky-header .site-title {
	    line-height: var(--thsn-grevo-sticky-header-height) !important;
	    height: var(--thsn-grevo-sticky-header-height) !important;
	}
	.thsn-navbar ul > li > ul > li.current-menu-item > a,
	.thsn-navbar ul > li > ul li.current_page_item > a,
	.thsn-navbar ul > li > ul li.current_page_ancestor > a,
	.thsn-navbar > div > ul > li:hover > a,
	.thsn-navbar > div > ul > li.current_page_item > a,
	.thsn-navbar > div > ul > li.current-menu-parent > a {
	   color: var(--thsn-grevo-global-color);
	}
	.thsn-navbar ul > li > ul li.current_page_item > a:before,
	.thsn-navbar ul > li > ul li.current_page_ancestor > a:before,
	.thsn-navbar ul > li > ul li.current_page_parent > a:before{
		 background-color: var(--thsn-grevo-global-color);
	}
	.thsn-navbar ul > li > ul li:hover > a {
		color: var(--thsn-grevo-global-color) !important;
	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar > div > ul {
	   position: relative;
	   z-index: 597;
	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar > div > ul > li {
	   float: left;
	   min-height: 1px;
	   vertical-align: middle;
	   position: relative;
	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar > div > ul ul {
	   visibility: hidden;
	   position: absolute;
	   top: 100%;
	   left: 0;
	   z-index: 598;
	}
	.thsn-navbar ul > li:hover > ul{
		z-index: 600;
	}
	.thsn-navbar > div > ul li ul.thsn-nav-left{
	    left: inherit;
	    right: 0;		
	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar > div > ul li ul ul.thsn-nav-left{
	    left: -100%;
	    right: 0;
		-webkit-transition: none;
		transition: none;
	}	
	.thsn-navbar > div > ul ul li {
	   float: none;
	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar > div > ul ul ul {
	   top: 0;
	   left: 100%;
	   width: 190px;
	}
	.thsn-navbar > div > ul ul {
	  margin-top: 0;
	}
	.thsn-navbar > div > ul ul li {
	    font-weight: normal;
	}
	.thsn-navbar a {
	    display: block;
	    line-height: 1em;
	    text-decoration: none;
	}
	/* Custom CSS Styles */
	.thsn-navbar > ul {
		*display: inline-block;
	}
	.thsn-navbar:after,
	.thsn-navbar ul:after {
		content: '';
		display: block;
		clear: both;
	}
	.thsn-navbar ul {
		text-transform: uppercase;
	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar ul ul {
		min-width: 270px;
		opacity: 0;
		visibility: hidden;
		-webkit-transition: all 0.3s linear 0s;
		transition: all 0.3s linear 0s;
		box-shadow: 0px 10px 40px rgba(0,0,0,0.20);
		border-top: 3px solid var(--thsn-grevo-global-color);
	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar ul > li:hover > ul {
		visibility: visible;
		opacity: 1;
	}
	.thsn-navbar ul > li > ul > li > a{
		padding: 15px 30px;

	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar ul > li > ul > li:hover > a{
		padding-left: 40px;
	}
	.thsn-navbar ul ul a {
		border-bottom: 1px solid rgba(0, 0, 0, 0.10);
		border-top: 0 none;
		line-height: 150%;
		padding: 12px 20px;
		-webkit-transition: all .500s ease-in-out;
    	transition: all .500s ease-in-out;
	}
	.thsn-navbar ul ul ul {
		border-top: 0 none;
	}
	.thsn-navbar ul ul li {
		position: relative;
	}
	.thsn-navbar ul li.last ul {
		left: auto;
		right: 0;
	}
	.thsn-navbar ul li.last ul ul {
		left: auto;
		right: 99.5%;
	}
	body:not(.thsn-max-mega-menu-override) .thsn-navbar div > ul > li > a{
		margin: 0 20px;
		-webkit-transition: all .500s ease-in-out;
    	transition: all .500s ease-in-out;
	}

	/* Dropdown Menu ( Globalcolor )*/
	.thsn-navbar.thsn-dropdown-active-color-globalcolor ul > li > ul > li.current-menu-item > a, 
	.thsn-navbar.thsn-dropdown-active-color-globalcolor ul > li > ul li.current_page_item > a, 
	.thsn-navbar.thsn-dropdown-active-color-globalcolor ul > li > ul li.current_page_ancestor > a,
	/* Main Menu ( Globalcolor )*/
	.thsn-navbar.thsn-main-active-color-globalcolor > div > ul > li:hover > a, 
	.thsn-navbar.thsn-main-active-color-globalcolor > div > ul > li.current_page_item > a, 
	.thsn-navbar.thsn-main-active-color-globalcolor > div > ul >li.current-menu-parent > a{
	    color: var(--thsn-grevo-global-color);
	}
	/* Dropdown Menu ( Secondarycolor )*/
	.thsn-navbar.thsn-dropdown-active-color-secondarycolor ul > li > ul > li.current-menu-item > a, 
	.thsn-navbar.thsn-dropdown-active-color-secondarycolor ul > li > ul li.current_page_item > a, 
	.thsn-navbar.thsn-dropdown-active-color-secondarycolor ul > li > ul li.current_page_ancestor > a,
	/* Main Menu ( Secondarycolor )*/
	.thsn-navbar.thsn-main-active-color-secondarycolor > div > ul > li:hover > a, 
	.thsn-navbar.thsn-main-active-color-secondarycolor > div > ul > li.current_page_item > a, 
	.thsn-navbar.thsn-main-active-color-secondarycolor > div > ul >li.current-menu-parent > a{
	    color: var(--thsn-grevo-secondary-color);
	}
	.thsn-header-menu-area .thsn-navbar div > ul > li,
	.thsn-header-menu-area .thsn-navbar div > ul > li > a,
	.thsn-header-menu-area{
		height: 62px;
		line-height: 62px !important;
	}
	.thsn-header-menu-area.thsn-sticky-on .thsn-navbar div > ul > li,
	.thsn-header-menu-area.thsn-sticky-on .thsn-navbar div > ul > li > a,
	.thsn-header-menu-area.thsn-sticky-on{
		height: 62px;
		line-height: 62px !important;
	}
	.thsn-header-menu-area{
	    position: relative;
	    z-index: 10;
	} 
	.thsn-navbar > div > ul > li.menu-item-has-children,
	.thsn-navbar > div > ul > li.page_item_has_children{
		padding-right: 10px;
	}	
	.thsn-navbar > div > ul > li.menu-item-has-children:after,
	.thsn-navbar > div > ul > li.page_item_has_children:after{
		font-family: "themesion-base-icons";
		font-size: 11px;
		content: "\e811";
		position: absolute;
		top: 1px;
		right: 5px;		
		-webkit-transition: all .500s ease-in-out;
    	transition: all .500s ease-in-out;
	}
	.thsn-navbar > div > ul > li.current-menu-parent.menu-item-has-children:after{
		color: var(--thsn-grevo-global-color);
	}
	.thsn-sticky-header .thsn-navbar > div > ul > li.current-menu-parent.menu-item-has-children:after {
		color: var(--thsn-grevo-main-menu-sticky-active-color);
	}
	/*=== thsn-search-cart-box ===*/
	.thsn-search-cart-box .thsn-cart-wrapper a,
	.thsn-search-cart-box .thsn-header-search-btn a{
		font-size: 20px;
	}
	.thsn-search-cart-box .thsn-cart-wrapper a .amount{
		font-size: 16px;
	}
	.thsn-search-cart-box{
		display: flex;
		align-items: center;
		position: relative;
	}
	.thsn-search-cart-box > *{
		padding: 0 20px;
		position: relative;
	}
	.thsn-search-cart-box > *:nth-child(2)::after{
		content: '';
		width: 1px;
		height: 30px;
		background-color: rgba(var(--thsn-grevo-blackish-bg-color-rgb), 0.20);
		position: absolute;
		left: 0px;
		top: 50%;
		-webkit-transform: translateY(-50%);
		-ms-transform: translateY(-50%);
		transform: translateY(-50%);
	}
	.thsn-search-cart-box .thsn-cart-wrapper a,
	.thsn-search-cart-box .thsn-cart-details{
		position: relative;
	}
	.thsn-search-cart-box .thsn-cart-count{
		position: absolute;
		top: -18px;
		left: -18px;
		background-color: var(--thsn-grevo-global-color);
		color: #fff;
		height: 20px;
		line-height: 20px;
		width: 20px;
		text-align: center;
		border-radius: 50%;
		font-size: 12px;
	}
	.thsn-search-cart-box .thsn-cart-wrapper a:before {
	    content: "\e83b";
		font-family: "themesion-base-icons";
		font-size: 22px;
		line-height: 22px;
		font-weight: normal;
	}
}
/*====================================  End Min Break Point  ====================================*/

<?php if( !empty($preheader_responsive) ){ ?>
@media screen and (max-width: <?php echo esc_html($preheader_responsive); ?>px) {
	.thsn-pre-header-wrapper{
		display: none;
	}
}
<?php } ?>
<?php
$footer_column	= thsn_get_base_option('footer-column');
if( $footer_column=='custom' ) :
	$footer_column_1	= thsn_get_base_option('footer-1-col-width');
	$footer_column_2	= thsn_get_base_option('footer-2-col-width');
	$footer_column_3	= thsn_get_base_option('footer-3-col-width');
	$footer_column_4	= thsn_get_base_option('footer-4-col-width');
	?>
	@media screen and (min-width: 992px) {
		<?php if( !empty($footer_column_1) && $footer_column_1!='hide' ) : ?>
		.site-footer .thsn-footer-widget.thsn-footer-widget-col-1{
			-ms-flex: 0 0 var(--thsn-grevo-footer-1-col-width);
			flex: 0 0 var(--thsn-grevo-footer-1-col-width);
			max-width: var(--thsn-grevo-footer-1-col-width);
		}
		<?php endif; ?>
		<?php if( !empty($footer_column_2) && $footer_column_2!='hide' ) : ?>
		.site-footer .thsn-footer-widget.thsn-footer-widget-col-2{
			-ms-flex: 0 0 var(--thsn-grevo-footer-2-col-width);
			flex: 0 0 var(--thsn-grevo-footer-2-col-width);
			max-width: var(--thsn-grevo-footer-2-col-width);
		}
		<?php endif; ?>
		<?php if( !empty($footer_column_3) && $footer_column_3!='hide' ) : ?>
		.site-footer .thsn-footer-widget.thsn-footer-widget-col-3{
			-ms-flex: 0 0 var(--thsn-grevo-footer-3-col-width);
			flex: 0 0 var(--thsn-grevo-footer-3-col-width);
			max-width: var(--thsn-grevo-footer-3-col-width);
		}
		<?php endif; ?>
		<?php if( !empty($footer_column_4) && $footer_column_4!='hide' ) : ?>
		.site-footer .thsn-footer-widget.thsn-footer-widget-col-4{
			-ms-flex: 0 0 var(--thsn-grevo-footer-4-col-width);
			flex: 0 0 var(--thsn-grevo-footer-4-col-width);
			max-width: var(--thsn-grevo-footer-4-col-width);
		}
		<?php endif; ?>
	}
<?php endif; ?>
