<?php
/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
if( !function_exists('thsn_widgets_init_20') ){
function thsn_widgets_init_20() {
	register_sidebar( array(
		'name'          => esc_attr__( 'Blog Sidebar', 'grevo' ),
		'id'            => 'thsn-sidebar-post',
		'description'   => esc_attr__( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'grevo' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_attr__( 'Page Sidebar', 'grevo' ),
		'id'            => 'thsn-sidebar-page',
		'description'   => esc_attr__( 'Add widgets here to appear in your sidebar on pages.', 'grevo' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
}
add_action( 'widgets_init', 'thsn_widgets_init_20', 20 );
if( !function_exists('thsn_widgets_init_22') ){
function thsn_widgets_init_22() {
	register_sidebar( array(
		'name'          => esc_attr__( 'Search Results Sidebar', 'grevo' ),
		'id'            => 'thsn-sidebar-search',
		'description'   => esc_attr__( 'Add widgets here to appear on search result pages.', 'grevo' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_attr__( 'Footer Row - 1st Column', 'grevo' ),
		'id'            => 'thsn-footer-1',
		'description'   => esc_attr__( 'Add widgets here to appear in your footer.', 'grevo' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_attr__( 'Footer Row - 2nd Column', 'grevo' ),
		'id'            => 'thsn-footer-2',
		'description'   => esc_attr__( 'Add widgets here to appear in your footer.', 'grevo' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_attr__( 'Footer Row - 3rd Column', 'grevo' ),
		'id'            => 'thsn-footer-3',
		'description'   => esc_attr__( 'Add widgets here to appear in your footer.', 'grevo' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
	register_sidebar( array(
		'name'          => esc_attr__( 'Footer Row - 4th Column', 'grevo' ),
		'id'            => 'thsn-footer-4',
		'description'   => esc_attr__( 'Add widgets here to appear in your footer.', 'grevo' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
	) );
}
}
add_action( 'widgets_init', 'thsn_widgets_init_22', 22 );

/**
 * Customizer icon picker
 */
if( !function_exists('thsn_grevo_addons_configure_customizer') ){
function thsn_grevo_addons_configure_customizer(){
	if( class_exists('Kirki') ){
		/** Kirki icon picker **/
		include( get_template_directory() . '/includes/customizer/themesion-icon-picker/themesion-icon-picker.php' );
	}
}
}
add_action( 'init', 'thsn_grevo_addons_configure_customizer' );

/**
 *  Disable Legacy mode
 */
if( !function_exists('thsn_elementor_set_legacy_mode') ){
function thsn_elementor_set_legacy_mode(){
	$optimized_dom_output = get_option( 'elementor_optimized_dom_output' );
	if( $optimized_dom_output!='enabled' ){
		update_option( 'elementor_optimized_dom_output', 'enabled' );
	}
}
}
add_action( 'init', 'thsn_elementor_set_legacy_mode' );

/**
 *  Customizer options
 */
if( !function_exists('thsn_configure_customizer') ){
function thsn_configure_customizer(){
	if( class_exists('Kirki') ){
		include( get_template_directory() . '/includes/kirki-config.php' );
	}
}
}
add_action( 'init', 'thsn_configure_customizer', 99 );

/**
 *  Categories Widget - Wrap Post count in a span
 */
add_filter('wp_list_categories', 'thsn_cat_count_span');
if( !function_exists('thsn_cat_count_span') ){
function thsn_cat_count_span($links) {
	if(strpos($links, '<span class="count">') !== false){
		// WooComerce call
		$links = str_replace('<span class="count">(', '<span class="count">', $links);
		$links = str_replace(')</span>', '</span>', $links);
	} else {
		$links = str_replace('</a> (', '</a> <span>', $links);
		$links = str_replace(')', '</span>', $links);

	}
	return $links;
}
}

/**
 *  Archives Widget - Wrap Post count in a span
 */
add_filter('get_archives_link', 'thsn_archive_count_span');
if( !function_exists('thsn_archive_count_span') ){
function thsn_archive_count_span($links) {
	if( substr( trim($links), 0, 8 ) != '<option ' ){
		$links = str_replace('</a>&nbsp;(', '</a> <span>', $links);
		$links = str_replace(')', '</span>', $links);
	}
	return $links;
}
}

/**
 * Specially for Forminator plugin
 */
if( !function_exists('thsn_forminator_plugin_js_correction') ){
	function thsn_forminator_plugin_js_correction(){
		$curr_screen = get_current_screen();
		if( !empty($curr_screen->base) && $curr_screen->base == 'customize' ){
			wp_enqueue_script( 'select2-forminator', get_template_directory_uri() . '/js/select2-forminator.min.js' );
		}
	}
}
add_action( 'admin_enqueue_scripts', 'thsn_forminator_plugin_js_correction', 99 );

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
if( !function_exists('thsn_pingback_header') ){
function thsn_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">' . "\n", get_bloginfo( 'pingback_url' ) );
	}
}
}
add_action( 'wp_head', 'thsn_pingback_header' );

/**
 * Enqueue scripts and styles.
 */
if( !function_exists('thsn_style_scripts') ){
function thsn_style_scripts() {

	$min = '';
	if( thsn_get_base_option('min')=='1' ){
		$min = '.min';
	}

	// header style css
	$header_style = thsn_get_base_option('header-style');
	if( empty($header_style) ){ $header_style = '1'; }
	if( file_exists( get_template_directory() . '/css/header/header-style-'.$header_style.$min.'.css' ) ){
		wp_enqueue_style( 'thsn-grevo-header-style', get_template_directory_uri() . '/css/header/header-style-'.$header_style.$min.'.css' );
	}

	// Blog box styles
	$blog_styles = thsn_element_template_list('blog', true);
	$total_blog_styles = count($blog_styles);
	if( is_array($blog_styles) && $total_blog_styles>0 ){
		foreach( $blog_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/blog/blog-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-blog-style-'.$style, get_template_directory_uri() . '/css/blog/blog-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-blog-style-'.$style, get_template_directory_uri() . '/css/blog/blog-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	  // blog but not classic

	  $blogroll_view = thsn_get_base_option('blogroll-view');
	  if( is_home() && $blogroll_view!='classic' ){
		  wp_enqueue_style( 'thsn-blog-style-'.$blogroll_view, get_template_directory_uri() . '/css/blog/blog-style-'.$blogroll_view.$min.'.css' );
	  }

	// Client box styles
	$client_styles = thsn_element_template_list('client', true);
	$total_client_styles = count($client_styles);
	if( is_array($client_styles) && $total_client_styles>0 ){
		foreach( $client_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/client/client-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-client-style-'.$style, get_template_directory_uri() . '/css/client/client-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-client-style-'.$style, get_template_directory_uri() . '/css/client/client-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	// FID box styles
	$fid_styles = thsn_element_template_list('facts-in-digits', true);
	$total_fid_styles = count($fid_styles);
	if( is_array($fid_styles) && $total_fid_styles>0 ){
		foreach( $fid_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/fid/fid-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-fid-style-'.$style, get_template_directory_uri() . '/css/fid/fid-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-fid-style-'.$style, get_template_directory_uri() . '/css/fid/fid-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	// Icon Heading box styles
	$icon_heading_styles = thsn_element_template_list('icon-heading', true);
	$total_icon_heading_styles = count($icon_heading_styles);
	if( is_array($icon_heading_styles) && $total_icon_heading_styles>0 ){
		foreach( $icon_heading_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/icon-heading/icon-heading-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-icon-heading-style-'.$style, get_template_directory_uri() . '/css/icon-heading/icon-heading-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-icon-heading-style-'.$style, get_template_directory_uri() . '/css/icon-heading/icon-heading-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	// Pricing Table box styles
	$pricing_table_styles = thsn_element_template_list('pricing-table', true);
	$total_pricing_table_styles = count($pricing_table_styles);
	if( is_array($pricing_table_styles) && $total_pricing_table_styles>0 ){
		foreach( $pricing_table_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/ptable/ptable-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-ptable-style-'.$style, get_template_directory_uri() . '/css/ptable/ptable-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-ptable-style-'.$style, get_template_directory_uri() . '/css/ptable/ptable-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	// Testimonial box styles
	$testimonial_styles = thsn_element_template_list('testimonial', true);
	$total_testimonial_styles = count($testimonial_styles);
	if( is_array($testimonial_styles) && $total_testimonial_styles>0 ){
		foreach( $testimonial_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/testimonial/testimonial-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-testimonial-style-'.$style, get_template_directory_uri() . '/css/testimonial/testimonial-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-testimonial-style-'.$style, get_template_directory_uri() . '/css/testimonial/testimonial-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	// Team box styles
	$team_styles = thsn_element_template_list('team', true);
	$total_team_styles = count($team_styles);
	if( is_array($team_styles) && $total_team_styles>0 ){
		foreach( $team_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/team/team-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-team-style-'.$style, get_template_directory_uri() . '/css/team/team-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-team-style-'.$style, get_template_directory_uri() . '/css/team/team-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	// Portfolio box styles
	$portfolio_styles = thsn_element_template_list('portfolio', true);
	$total_portfolio_styles = count($portfolio_styles);
	if( is_array($portfolio_styles) && $total_portfolio_styles>0 ){
		foreach( $portfolio_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/portfolio/portfolio-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-portfolio-style-'.$style, get_template_directory_uri() . '/css/portfolio/portfolio-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-portfolio-style-'.$style, get_template_directory_uri() . '/css/portfolio/portfolio-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	// Service box styles
	$service_styles = thsn_element_template_list('service', true);
	$total_service_styles = count($service_styles);
	if( is_array($service_styles) && $total_service_styles>0 ){
		foreach( $service_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/service/service-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-service-style-'.$style, get_template_directory_uri() . '/css/service/service-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-service-style-'.$style, get_template_directory_uri() . '/css/service/service-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	// Static box styles
	$static_box_styles = thsn_element_template_list('static-box', true);
	$total_static_box_styles = count($static_box_styles);
	if( is_array($static_box_styles) && $total_static_box_styles>0 ){
		foreach( $static_box_styles as $style=>$image ){
			if( file_exists( get_template_directory() . '/css/static-box/static-box-style-'.$style.$min.'.css' ) ){
				if( (defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode()) || is_search() ){
					wp_enqueue_style( 'thsn-static-box-style-'.$style, get_template_directory_uri() . '/css/static-box/static-box-style-'.$style.$min.'.css' );
				} else {
					wp_register_style( 'thsn-static-box-style-'.$style, get_template_directory_uri() . '/css/static-box/static-box-style-'.$style.$min.'.css' );
				}
			}
		}
	}

	if( is_singular( 'post' ) ){
		$style	= thsn_get_base_option('blog-related-style');
		wp_enqueue_style( 'thsn-blog-style-'.$style);
	} else if ( is_singular( 'thsn-portfolio' ) ){
		$style	= thsn_get_base_option('portfolio-related-style');
		wp_enqueue_style( 'thsn-portfolio-style-'.$style);
	} else if ( is_singular( 'thsn-service' ) ){
		$style	= thsn_get_base_option('service-related-style');
		wp_enqueue_style( 'thsn-service-style-'.$style);
	}

	// Portfolio Category view styles
	if( is_tax('thsn-portfolio-category') || is_post_type_archive('thsn-portfolio') ){
		$portfolio_cat_style = thsn_get_base_option('portfolio-cat-style');
		$portfolio_cat_style = ( empty($portfolio_cat_style) ) ? '1' : $portfolio_cat_style ;
		wp_enqueue_style( 'thsn-portfolio-style-'.$portfolio_cat_style, get_template_directory_uri() . '/css/portfolio/portfolio-style-'.$portfolio_cat_style.$min.'.css' );
	}

	// Service Category view styles
	if( is_tax('thsn-service-category') || is_post_type_archive('thsn-service') ){
		$service_cat_style = thsn_get_base_option('service-cat-style');
		$service_cat_style = ( empty($service_cat_style) ) ? '1' : $service_cat_style ;
		wp_enqueue_style( 'thsn-service-style-'.$service_cat_style, get_template_directory_uri() . '/css/service/service-style-'.$service_cat_style.$min.'.css' );
	}

	// Team Group view styles
	if( is_tax('thsn-team-group') || is_post_type_archive('thsn-team-member') ){
		$team_group_style = thsn_get_base_option('team-group-style');
		$team_group_style = ( empty($team_group_style) ) ? '1' : $team_group_style ;
		wp_enqueue_style( 'thsn-team-style-'.$team_group_style, get_template_directory_uri() . '/css/team/team-style-'.$team_group_style.$min.'.css' );
	}

	// Post Category view styles
	if( is_archive('category') || is_post_type_archive('post') ){
		$post_cat_style = thsn_get_base_option('blogroll-view');
		if( $post_cat_style!='classic') {
			$post_cat_style = ( empty($post_cat_style) ) ? '1' : $post_cat_style ;
			wp_enqueue_style( 'thsn-post-category-style-'.$post_cat_style, get_template_directory_uri() . '/css/blog/blog-style-'.$post_cat_style.$min.'.css' );
		}
	}

	if( is_page() || is_singular() ){
		$elementor_data  = get_post_meta( get_the_ID() , '_elementor_data', true );
		$elementor_page = get_post_meta( get_the_ID(), '_elementor_edit_mode', true );

		if( !empty($elementor_data) && !empty($elementor_page) ){

			if( is_array($elementor_data) ){
				$contents_array = $elementor_data;
			} else {
				$contents_array = json_decode($elementor_data, true);
			}

			if( !empty($contents_array) && is_array($contents_array) ){
				$elements = thsn_get_elements($contents_array);
				if( !empty($elements) && is_array($elements) && count($elements)>0 ){
					foreach( $elements as $element ){
						$ele = explode('___', $element);

						$css_id = $ele[0];
						$style = $ele[1];

						$css_id = str_replace('_element','-style', $css_id );
						$css_id = str_replace('_','-', $css_id );
						$css_id = str_replace('_','-', $css_id );
						$css_id = str_replace('_','-', $css_id );

						if( $css_id == 'thsn-icon-heading' ){
							$css_id .= '-style';
						}
						if( $css_id == 'thsn-multiple-icon-heading' ){
							$css_id = 'thsn-icon-heading-style';
						}

						if( $css_id !='thsn-heading' ){ // there is no style css for heading
							$css_id = $css_id.'-'.$style;
							wp_enqueue_style( esc_attr($css_id) );
						}

					}
				}
			}
		}
	}
}
}
add_action( 'wp_enqueue_scripts', 'thsn_style_scripts', 10 );

/**
 * Enqueue scripts and styles.
 */
if( !function_exists('thsn_scripts') ){
function thsn_scripts() {
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	$min = '';
	if( thsn_get_base_option('min')=='1' ){
		$min = '.min';
	}

	// RTL 
	$rtl = ( is_rtl() ) ? '-rtl' : '' ;

	// Font Awesome base
	if( !wp_style_is( 'elementor-icons-shared-0', 'registered' ) ){
		wp_register_style( 'elementor-icons-shared-0', get_template_directory_uri() . '/libraries/font-awesome/css/fontawesome.min.css' );
	}
	$icon_libraries = thsn_icon_library_list();
	foreach( $icon_libraries as $library_id=>$library_data ){
		if( !wp_style_is( $library_id, 'registered' ) ){
			wp_register_style( $library_id, $library_data['css_path'] );
		}
	}

	if( defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode() || is_search()){
		$icon_libraries = thsn_icon_library_list();
		foreach( $icon_libraries as $library_id=>$library_data ){
			if( wp_style_is( $library_id, 'registered' ) ){
				wp_enqueue_style( $library_id, $library_data['css_path'] );
			}
		}
		if( wp_style_is( 'elementor-icons-shared-0', 'registered' ) ){
			wp_enqueue_style( 'elementor-icons-shared-0' );
		}
		if( wp_style_is( 'elementor-icons-fa-regular', 'registered' ) ){
			wp_enqueue_style( 'elementor-icons-fa-regular' );
		}
		if( wp_style_is( 'elementor-icons-fa-solid', 'registered' ) ){
			wp_enqueue_style( 'elementor-icons-fa-solid' );
		}
		if( wp_style_is( 'elementor-icons-fa-brands', 'registered' ) ){
			wp_enqueue_style( 'elementor-icons-fa-brands' );
		}
	}

	// Bootstrap
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/libraries/bootstrap/css/bootstrap'.$rtl.'.min.css' );

	wp_register_script( 'jquery-waypoints', get_template_directory_uri() . '/libraries/waypoints/jquery.waypoints.min.js' , array( 'jquery' ) );
	wp_register_style( 'animate-css', get_template_directory_uri() . '/libraries/animate-css/animate.min.css' );

	wp_register_script( 'jquery-circle-progress', get_template_directory_uri() . '/libraries/jquery-circle-progress/circle-progress.min.js', array( 'jquery' ) );
	wp_register_script( 'numinate', get_template_directory_uri() . '/libraries/numinate/numinate.min.js', array( 'jquery' ) );

	wp_register_script( 'owl-carousel', get_template_directory_uri() . '/libraries/owl-carousel/owl.carousel.min.js' , array( 'jquery' ) );
	wp_register_style( 'owl-carousel', get_template_directory_uri() . '/libraries/owl-carousel/assets/owl.carousel.min.css' );
	wp_register_style( 'owl-carousel-theme', get_template_directory_uri() . '/libraries/owl-carousel/assets/owl.theme.default.min.css' );

	wp_enqueue_style( 'thsn-elementor-style', get_template_directory_uri() . '/css/elementor'.$min.'.css' );

	wp_enqueue_style( 'thsn-core-style', get_template_directory_uri() . '/css/core'.$min.'.css' );
	wp_enqueue_style( 'thsn-theme-style', get_template_directory_uri() . '/css/theme'.$min.'.css' );

	// WooCommerce
	if( function_exists('is_woocommerce') ){
		wp_enqueue_style( 'thsn-woocommerce-style', get_template_directory_uri() . '/css/woocommerce'.$min.'.css' );
	}

	// Select2
	wp_enqueue_script( 'select2', get_template_directory_uri() . '/libraries/select2/js/select2.min.js', array('jquery') );
	wp_enqueue_style( 'select2', get_template_directory_uri() . '/libraries/select2/css/select2.min.css' );

	// Magnific Popup Lightbox
	wp_enqueue_script( 'magnific-popup', get_template_directory_uri() . '/libraries/magnific-popup/jquery.magnific-popup.min.js', array('jquery') );
	wp_enqueue_style( 'magnific-popup', get_template_directory_uri() . '/libraries/magnific-popup/magnific-popup.css' );
	// Base icon library
	wp_enqueue_style( 'thsn-base-icons', get_template_directory_uri() . '/libraries/themesion-base-icons/css/themesion-base-icons.css' );
	// Sticky
	if( thsn_get_base_option('sticky-header')==true ){
		wp_enqueue_script( 'jquery-sticky', get_template_directory_uri() . '/libraries/sticky-toolkit/jquery.sticky-kit.min.js' , array('jquery') );
	}
	// Theme base scripts
	wp_enqueue_script( 'thsn-core-script', get_template_directory_uri() . '/js/core'.$min.'.js' , array('jquery') );
	wp_enqueue_script( 'thsn-elementor-script', get_template_directory_uri() . '/js/elementor'.$min.'.js', array('jquery', 'thsn-core-script') );
	// Responsive variable
	$js_array = array(
		'responsive'	=> thsn_get_base_option('responsive-breakpoint'),
		'ajaxurl'		=> admin_url( 'admin-ajax.php' ),
		'ajaxnonce'		=> wp_create_nonce( 'thsn_infinite_scroll_ajax_validation' ) 
	);
	wp_localize_script( 'thsn-core-script', 'thsn_js_variables', $js_array );
	// ballon tooltip
	wp_enqueue_style( 'balloon', get_template_directory_uri() . '/libraries/balloon/balloon.min.css' );
	// Light Slider
	wp_register_script( 'lightslider', get_template_directory_uri() . '/libraries/lightslider/js/lightslider.min.js' , array('jquery') );
	wp_register_style( 'lightslider', get_template_directory_uri() . '/libraries/lightslider/css/lightslider.min.css' );
	// Isotope
	wp_register_script( 'isotope', get_template_directory_uri() . '/libraries/isotope/isotope.pkgd.min.js' , array('jquery') );
	// Infinite Scroll
	wp_register_script( 'infinite-scroll', get_template_directory_uri() . '/libraries/infinite-scroll/infinite-scroll.pkgd.min.js' , array( 'jquery', 'isotope' ) );
	// Masonry
	wp_register_script( 'masonry', array( 'jquery', 'infinite-scroll' ) );

	// Max Mega Menu style
	$mmmenu_override = thsn_get_base_option('max-mega-menu-override');
	if( $mmmenu_override == 1 && defined('MEGAMENU_VERSION') ){
		wp_enqueue_style( 'thsn-max-mega-menu', get_template_directory_uri() . '/css/max-mega-menu'.$min.'.css' );
	}

	/******************** */

	// Category icon library
	if( is_tax() ){
		if( is_tax() ){
			$category = get_queried_object();
			if( isset($category->term_id) && !empty($category->term_id) ){
				$cat_id			= $category->term_id;
				$term			= get_term( $cat_id );
				$sub_category	= get_terms( $term->taxonomy, array('parent' => $cat_id, 'hide_empty' => false) );
				if( is_array($sub_category) && count($sub_category)>0 ){
					foreach( $sub_category as $cat ){
						$icon_lib = get_term_meta( $cat->term_id, 'thsn-category-icon-library', true );
						wp_enqueue_style($icon_lib);
					}
				}
			}
		}
	}

	if( function_exists('thsn_auto_css') ){
		// Addons plugin exists
		if( function_exists('is_customize_preview') && !is_customize_preview() ){
			wp_enqueue_style('thsn-dynamic-style', admin_url('admin-ajax.php').'?action=thsn_auto_css');
		} else {
			ob_start();
			include get_template_directory().'/css/theme-style.php'; // Fetching theme-style.php output and store in a variable
			$css    = ob_get_clean();
			wp_add_inline_style( 'thsn-theme-style', $css );
		}
	} else {
		// Addons plugin not exists
		wp_enqueue_style( 'thsn-dynamic-default-style', get_template_directory_uri() . '/css/dynamic-default-style'.$min.'.css' );
	}

	wp_enqueue_style( 'thsn-responsive-style', get_template_directory_uri() . '/css/responsive'.$min.'.css' );

	global $thsn_inline_css;
	if( !empty($thsn_inline_css) ){
		if( function_exists('thsn_minify_css') ){
			$thsn_inline_css = thsn_minify_css( $thsn_inline_css );
		}
		wp_add_inline_style( 'thsn-dynamic-style', trim( $thsn_inline_css ) );
	}

	if( is_page() || is_singular() ){
		if( wp_style_is( 'elementor-post-'.get_the_ID() , 'enqueued' ) ){
			wp_dequeue_style( 'elementor-post-'.get_the_ID() );
			wp_enqueue_style( 'elementor-post-'.get_the_ID() );
		}
	}

	if ( defined('ELEMENTOR_VERSION') && \Elementor\Plugin::$instance->preview->is_preview_mode() ) {
		wp_enqueue_script( 'jquery-waypoints' );
		wp_enqueue_style( 'animate-css' );

		wp_enqueue_script( 'jquery-circle-progress' );
		wp_enqueue_script( 'numinate' );

		wp_enqueue_script( 'owl-carousel' );
		wp_enqueue_style( 'owl-carousel' );
		wp_enqueue_style( 'owl-carousel-theme' );

		wp_enqueue_script( 'lightslider' );
		wp_enqueue_style( 'lightslider' );
	}

	// For the Search Results page
	if( is_search() ){
		wp_enqueue_style( 'thsn-search-results', get_template_directory_uri() . '/css/search-results'.$min.'.css' );
		wp_enqueue_style( 'skeletabs', get_template_directory_uri() . '/libraries/skeletabs/skeletabs.min.css' );
		wp_enqueue_script( 'skeletabs', get_template_directory_uri() . '/libraries/skeletabs/skeletabs.min.js' , array( 'jquery' ) );
	}

}
}
add_action( 'wp_enqueue_scripts', 'thsn_scripts', 20 );

/**
 * Admin scripts and styles
 */
if( !function_exists('thsn_wp_admin_scripts_styles') ){
function thsn_wp_admin_scripts_styles() {
	wp_register_script( 'thsn-admin-script', get_template_directory_uri() . '/includes/admin-script.js', array('jquery') );
	// Admin variable
	$admin_js_array = array(
		'theme_path' => get_template_directory_uri(),
	);
	wp_localize_script( 'thsn-admin-script', 'thsn_admin_js_variables', $admin_js_array );
	wp_enqueue_style( 'thsn-admin-style', get_template_directory_uri() . '/includes/admin-style.css' );
	wp_enqueue_script( 'thsn-admin-script' );
	wp_enqueue_style( 'wp-editor-classic-layout-styles' );
	// Admin widget view
	wp_enqueue_style( 'thsn-admin-widget-style', get_template_directory_uri() . '/includes/admin-widget.css' );

}
}
add_action( 'admin_enqueue_scripts', 'thsn_wp_admin_scripts_styles' );

/**
 * Enqueue script for custom customize control.
 */
function thsn_customize_enqueue() {
	wp_enqueue_script( 'thsn-customize-script', get_template_directory_uri() . '/includes/customizer-script.js', array( 'jquery', 'customize-controls' ), false, true );
}
add_action( 'customize_controls_enqueue_scripts', 'thsn_customize_enqueue' );

/**
 * Elementor correction for customize bug
 */
if( !function_exists('thsn_ele_correction') ){
function thsn_ele_correction() {
	if( function_exists('is_customize_preview') && is_customize_preview() ){
		if( wp_style_is( 'elementor-common', 'enqueued' ) ){
			wp_dequeue_style('elementor-common');
		}
		if( wp_style_is( 'elementor-admin', 'enqueued' ) ){
			wp_dequeue_style('elementor-admin');
		}
	}
}
}
add_action( 'admin_enqueue_scripts', 'thsn_ele_correction', 99 );

/**
 * Modifies tag cloud widget arguments to display all tags in the same font size
 * and use list format for better accessibility.
 *
 * @since Grevo 1.4
 *
 * @param array $args Arguments for tag cloud widget.
 * @return array The filtered arguments for tag cloud widget.
 */
if( !function_exists('thsn_widget_tag_cloud_args') ){
function thsn_widget_tag_cloud_args( $args ) {
	$args['largest']  = 1;
	$args['smallest'] = 1;
	$args['unit']     = 'em';
	$args['format']   = 'list';
	return $args;
}
}
add_filter( 'widget_tag_cloud_args', 'thsn_widget_tag_cloud_args' );

/*
 *  Body Tag: Class
 */
if( !function_exists('thsn_add_body_classes') ){
function thsn_add_body_classes($classes) {
	// Widget class
	$widget_class = '';

	// One Page site
	$onepage = thsn_get_base_option('onepage');
	if( $onepage == '1' ){
		$classes[] = 'thsn-one-page-site';
	}

	// sidebar class
	$sidebar_class = thsn_get_base_option('sidebar-post');
	if( in_array( $sidebar_class, array('left','right') ) ){
		$widget_class = thsn_check_widget_exists('thsn-sidebar-page');
	}
	if( is_page() ){
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-page');
		$page_meta = get_post_meta( get_the_ID(), 'thsn-sidebar', true );
		if( !empty($page_meta) && $page_meta!='global' ){
			$sidebar_class = $page_meta;
		}
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-page');
		}
		if( function_exists('is_woocommerce') && is_woocommerce() ){
			$widget_class = '';
			$sidebar_class = thsn_get_base_option('sidebar-wc-shop');
		}
		// Curved style at slider bottom
		$slider_type	= get_post_meta( get_the_ID(), 'thsn-slider-type', true );
		$curved_style	= get_post_meta( get_the_ID(), 'thsn-slider-curved-style', true );
		if( !empty($slider_type) && $curved_style == true ){
			$classes[] = 'thsn-slider-curved-style';
		}
	} else if ( !is_front_page() && is_home() ) {
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-post');
		$page_for_posts = get_option( 'page_for_posts' );
		$post_meta = get_post_meta( $page_for_posts, 'thsn-sidebar', true );
		if( !empty($post_meta) && $post_meta!='global' ){
			$sidebar_class = $post_meta;
		}
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-post');
		}

	} else if( function_exists('is_woocommerce') && is_woocommerce() && !is_product() ){
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-wc-shop');
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-wc-shop');
		}
	} else if( function_exists('is_product') && is_product() ){
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-wc-single');
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-wc-single');
		}
	} else if( is_singular() ){
		if( get_post_type()=='event_listing' ){
			$widget_class = '';
			$sidebar_class = thsn_get_base_option('sidebar-event-single');
			$post_meta = get_post_meta( get_the_ID(), 'thsn-sidebar', true );
			if( !empty($post_meta) && $post_meta!='global' ){
				$sidebar_class = $post_meta;
			}
			if( in_array( $sidebar_class, array('left','right') ) ){
				$widget_class = thsn_check_widget_exists('thsn-sidebar-event-single');
			}
		} else if( get_post_type()=='event_organizer' || get_post_type()=='event_venue' ){
			$widget_class = '';
			$sidebar_class = thsn_get_base_option('sidebar-event');
			$post_meta = get_post_meta( get_the_ID(), 'thsn-sidebar', true );
			if( !empty($post_meta) && $post_meta!='global' ){
				$sidebar_class = $post_meta;
			}
			if( in_array( $sidebar_class, array('left','right') ) ){
				$widget_class = thsn_check_widget_exists('thsn-sidebar-event');
			}
		} else if( get_post_type()=='thsn-portfolio' ){
			$widget_class = '';
			$sidebar_class = thsn_get_base_option('sidebar-portfolio');
			$post_meta = get_post_meta( get_the_ID(), 'thsn-sidebar', true );
			if( !empty($post_meta) && $post_meta!='global' ){
				$sidebar_class = $post_meta;
			}
			if( in_array( $sidebar_class, array('left','right') ) ){
				$widget_class = thsn_check_widget_exists('thsn-sidebar-portfolio');
			}
		} else if( get_post_type()=='thsn-service' ){
			$widget_class = '';
			$sidebar_class = thsn_get_base_option('sidebar-service');
			$post_meta = get_post_meta( get_the_ID(), 'thsn-sidebar', true );
			if( !empty($post_meta) && $post_meta!='global' ){
				$sidebar_class = $post_meta;
			}
			if( in_array( $sidebar_class, array('left','right') ) ){
				$widget_class = thsn_check_widget_exists('thsn-sidebar-service');
			}
		} else if( get_post_type()=='thsn-team-member' ){
			$widget_class = '';
			$sidebar_class = thsn_get_base_option('sidebar-team-member');
			$post_meta = get_post_meta( get_the_ID(), 'thsn-sidebar', true );
			if( !empty($post_meta) && $post_meta!='global' ){
				$sidebar_class = $post_meta;
			}
			if( in_array( $sidebar_class, array('left','right') ) ){
				$widget_class = thsn_check_widget_exists('thsn-sidebar-team');
			}
		} else if( get_post_type()=='post' ){
			$widget_class = '';
			$sidebar_class = thsn_get_base_option('sidebar-post');
			$post_meta = get_post_meta( get_the_ID(), 'thsn-sidebar', true );
			if( !empty($post_meta) && $post_meta!='global' ){
				$sidebar_class = $post_meta;
			}
			if( in_array( $sidebar_class, array('left','right') ) ){
				$widget_class = thsn_check_widget_exists('thsn-sidebar-post');
			}
		}
	} else if( is_tax('event_listing_category') || is_tax('event_listing_type') ){
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-event');
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-event');
		}
	} else if( is_tax('thsn-portfolio-category') || is_post_type_archive('thsn-portfolio') ){
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-portfolio-category');
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-portfolio-cat');
		}
	} else if( is_tax('thsn-service-category') || is_post_type_archive('thsn-service') ){
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-service-category');
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-service-cat');
		}
	} else if( is_tax('thsn-team-group') || is_post_type_archive('thsn-team-member') ){
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-team-group');
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-team-group');
		}
	} else if( is_search() ){
		$widget_class = '';
		$sidebar_class = thsn_get_base_option('sidebar-search');
		if( in_array( $sidebar_class, array('left','right') ) ){
			$widget_class = thsn_check_widget_exists('thsn-sidebar-search');
		}
	}
	// widget exists class
	if( !empty($widget_class) ){
		$classes[] = 'thsn-sidebar-no';
	} else {
		if( in_array( $sidebar_class, array('left','right') ) ){
			$classes[] = 'thsn-sidebar-exists';
		}
		$classes[] = 'thsn-sidebar-' . $sidebar_class;
	}
	// Max Mega Menu orverride class
	$mmmenu_override	= thsn_get_base_option('max-mega-menu-override');
	$megamenu_settings	= get_option( 'megamenu_settings' );
	if( $mmmenu_override == 1 && defined('MEGAMENU_VERSION') && ( isset($megamenu_settings['themesion-top']['enabled']) && !empty($megamenu_settings['themesion-top']['enabled']) && $megamenu_settings['themesion-top']['enabled']=='1' ) ){
		$classes[] = 'thsn-max-mega-menu-override';
	}
	return $classes;
}
}
add_filter('body_class', 'thsn_add_body_classes');

function thsn_update_comment_fields( $fields ) {

	if( is_singular('post') ){
		$commenter = wp_get_current_commenter();
		$req       = get_option( 'require_name_email' );
		$aria_req  = $req ? "aria-required='true'" : '';
		$fields['author'] =
			'<div class="thsn-comment-form-input-wrapper"><p class="thsn-comment-form-input comment-form-author">
				<input id="author" name="author" type="text" placeholder="' . esc_attr__( 'Name', 'grevo' ) . '" value="' . esc_attr( $commenter['comment_author'] ) .
			'" size="30" ' . $aria_req . ' />
			<span class="thsn-form-error thsn-error-author">'.esc_html__('This field is required.','grevo').'</span>
			</p>';
		$fields['email'] =
			'<p class="thsn-comment-form-input comment-form-email">
				<input id="email" name="email" type="email" placeholder="' . esc_attr__( 'Email', 'grevo' ) . '" value="' . esc_attr( $commenter['comment_author_email'] ) .
			'" size="30" ' . $aria_req . ' />
			<span class="thsn-form-error thsn-error-email thsn-empty-email">'.esc_html__('This field is required.','grevo').'</span>
			<span class="thsn-form-error thsn-error-email thsn-invalid-email">'.esc_html__('Please enter a valid email address.','grevo').'</span>	
			</p>';
		$fields['url'] =
			'<p class="thsn-comment-form-input comment-form-url">
				<input id="url" name="url" type="url"  placeholder="' . esc_attr__( 'Website', 'grevo' ) . '" value="' . esc_attr( $commenter['comment_author_url'] ) .
			'" size="30" />
				</p></div>';
	}
	return $fields;

}
add_filter( 'comment_form_default_fields', 'thsn_update_comment_fields' );

function thsn_update_comment_textarea_field( $comment_field ) {

	if( is_singular('post') ){

		$comment_field =
			'<p class="comment-form-comment">
			<textarea required id="comment" name="comment" placeholder="' . esc_attr__( "Enter your comment here...", 'grevo' ) . '" cols="45" rows="8"></textarea>
			<span class="thsn-form-error thsn-error-author">'.esc_html__('This field is required.','grevo').'</span>
			</p>';

	}
	return $comment_field;
}
add_filter( 'comment_form_field_comment', 'thsn_update_comment_textarea_field' );

// Limit Posts Per Category/Archive Page
add_filter('pre_get_posts', 'thsn_limit_category_posts');
function thsn_limit_category_posts($query){
    if( is_tax( 'thsn-portfolio-category' ) && !empty($query->query['thsn-portfolio-category']) ){
		$count		= thsn_get_base_option('portfolio-cat-count');
        $query->set('posts_per_page', $count);
    } else if( is_tax( 'thsn-team-group' ) && !empty($query->query['thsn-team-group']) ){
		$count		= thsn_get_base_option('team-group-count');
        $query->set('posts_per_page', $count);
	} else if( is_tax( 'thsn-service-category' ) && !empty($query->query['thsn-service-category']) ){
		$count		= thsn_get_base_option('service-cat-count');
        $query->set('posts_per_page', $count);
    }
    return $query;
}

/**
 * Show cart contents / total Ajax
 */
add_filter( 'woocommerce_add_to_cart_fragments', 'thsn_woocommerce_header_add_to_cart_fragment' );
if( !function_exists('thsn_woocommerce_header_add_to_cart_fragment') ){
function thsn_woocommerce_header_add_to_cart_fragment( $fragments ) {
	$content = thsn_woocommerce_header_fragement_content();
	$fragments['a.thsn-cart-link'] = thsn_esc_kses($content);
	return $fragments;
}
}

/**
 * Elementor core things
 */
include( get_template_directory() . '/includes/elementor-core.php' );

/**
 * Elementor global settings
 */
add_filter( 'admin_init', 'thsn_elementor_global_settings' );
if( !function_exists('thsn_elementor_global_settings') ){
function thsn_elementor_global_settings() {

	if(get_option('thsn_elementor_global_done') === false){

		// change default color
		$default_color = array (
			1 => '',
			2 => '',
			3 => '',
			4 => '',
		);
		update_option('elementor_scheme_color', $default_color );

		// change default typo
		$default_typo = array (
			1 => array (
				'font_family' => '',
				'font_weight' => '',
			),
			2 => array (
				'font_family' => '',
				'font_weight' => '',
			),
			3 => array (
				'font_family' => '',
				'font_weight' => '',
			),
			4 => array (
				'font_family' => '',
				'font_weight' => '',
			),
		);
		update_option('elementor_scheme_typography', $default_typo );

		// Set a flag if the theme activation happened
		update_option('thsn_elementor_global_done', true, '', false);
	}
}
}

/**
 * Init calls
 */
if( !function_exists('thsn_init_calls') ){
function thsn_init_calls(){
	$value = get_option('thsn-widget-classes');
	if( $value != 'yes' ){
		update_option(
			'WCSSC_options',
			array (
				'show_id'			=> false,
				'type'				=> 3,
				'defined_classes'	=> 
				array (
					0 => 'thsn-two-column-menu',
				),
				'show_number'		=> true,
				'show_location'		=> true,
				'show_evenodd'		=> true,
				'fix_widget_params'	=> false,
				'filter_unique'		=> false,
				'translate_classes'	=> false,
				)
		);
		update_option('thsn-widget-classes', 'yes');
	}

	// Removes the "shop" title on the main shop page
	add_filter( 'woocommerce_show_page_title', '__return_false' );

}
}
add_action( 'init', 'thsn_init_calls' );

/**
 *  Inline code generator
 */
if( !function_exists('thsn_inline_css_code_generator') ){
function thsn_inline_css_code_generator(){
	$return		= '';
	$color_css	= '';
	if( is_page() || is_singular() || is_home() ){
		$page_id = get_the_ID();

		if( is_home() ){
			$page_id = get_option( 'page_for_posts');
		}

		// Body background
		$bg_img		= get_post_meta( $page_id, 'thsn-bg-img', true );
		$bg_image	= $bg_color_css = $bg_color_opacity_css = '';

		if( !empty($bg_img) ){
			$img_src			= wp_get_attachment_image_src($bg_img, 'full');
			if( !empty($img_src[0]) ){ $bg_image = $img_src[0]; }
		}

		// Background color and color-opacity
		$bg_color			= get_post_meta( $page_id, 'thsn-bg-color', true );
		$bg_color_opacity	= get_post_meta( $page_id, 'thsn-bg-color-opacity', true );
		if( !empty($bg_color) ){
			$bg_color_css .= 'background-color:' . $bg_color . ' !important;';
		}
		if( !empty($bg_color_opacity) ){
			$bg_color_opacity_css .= 'opacity:' . $bg_color_opacity . ' !important;';
		}

		// Generating CSS for background
		if( !empty($bg_image) ){
			$return .= 'body{background-image:url(\'' . $bg_image . '\') !important;}';
			if( !empty($bg_color_css) ){
				$return .= 'body:before{' . $bg_color_css . $bg_color_opacity_css . '}';
			}

		} else {

			if( !empty($bg_color_css) ){
				$return .= 'body{' . $bg_color_css . '}';
			}

		}

		$titlebar_img = '';
		// Check if Titlebar bg imge is set in page or post
		$titlebar_bg_img	= get_post_meta( $page_id, 'thsn-titlebar-bg-img', true );
		if( !empty($titlebar_bg_img) ){
			$img_src			= wp_get_attachment_image_src($titlebar_bg_img, 'full');
			if( !empty($img_src[0]) ){ $titlebar_img = $img_src[0]; }
			$titlebar_bg_color			= get_post_meta( $page_id, 'thsn-titlebar-bg-color', true );
			$titlebar_bg_color_opacity	= get_post_meta( $page_id, 'thsn-titlebar-bg-color-opacity', true );
			if( !empty($titlebar_bg_color) ){
				$color_css .= 'background-color:' . $titlebar_bg_color . ' !important;';
			}
			if( !empty($titlebar_bg_color_opacity) ){
				$color_css .= 'opacity:' . $titlebar_bg_color_opacity . ' !important;';
			}
		} else {
			// If not than check now if fetaured img as titlebar bg option is enabled or not
			$titlebar_bg_featured = thsn_get_base_option('titlebar-bg-featured');
			if( !empty($titlebar_bg_featured) && is_array($titlebar_bg_featured) ){
				if( ( is_page()							&& in_array( 'page', $titlebar_bg_featured ) ) ||
					( is_singular('post')				&& in_array( 'post', $titlebar_bg_featured ) ) ||
					( is_singular('thsn-portfolio')		&& in_array( 'thsn-portfolio',   $titlebar_bg_featured ) ) ||
					( is_singular('thsn-team-member')	&& in_array( 'thsn-team-member', $titlebar_bg_featured ) ) ||
					( is_singular('thsn-testimonial')	&& in_array( 'thsn-testimonial', $titlebar_bg_featured ) ) ||
					( is_singular('thsn-service')		&& in_array( 'thsn-service',     $titlebar_bg_featured ) )
				){
					if( has_post_thumbnail() ){
						$titlebar_img = get_the_post_thumbnail_url( $page_id , 'full' );
					}
				}
			}
		}
		// Titlebar bg
		if( !empty($titlebar_img) ){
			$return .= '.thsn-title-bar-wrapper{background-image:url(\'' . $titlebar_img . '\') !important;}';
			if( !empty($color_css) ){
				$return .= '.thsn-title-bar-wrapper:before{' . $color_css . '}';
			}
		}
		// Titlebar BG Color
		$titlebar_bg_color	= get_post_meta( get_the_ID(), 'thsn-titlebar-bg-color', true );
		if( !empty($titlebar_bg_color) ){
			$opacity = get_post_meta( get_the_ID(), 'thsn-titlebar-bg-color-opacity', true );
			if( empty($opacity) ){ $opacity = '0.5'; }
			$return .= '.thsn-title-bar-wrapper:after{background-color:' . thsn_hex2rgb($titlebar_bg_color, $opacity ) . ' !important;}';
		}
	}
	if( !empty($return) ){
		thsn_inline_css( $return );
	}
}
}
add_action( 'wp', 'thsn_inline_css_code_generator' );

/**
 * Register a custom menu page.
 */
if( !function_exists('thsn_register_customizer_menu_page') ){
function thsn_register_customizer_menu_page() {
	if( class_exists('Kirki') ){
		add_menu_page(
			esc_attr__( 'Grevo Options', 'grevo' ),
			esc_attr__( 'Grevo Options', 'grevo' ),
			'manage_options',
			esc_url( home_url() . '/wp-admin/customize.php' ),
			'',
			'',
			6
		);
	}
}
}
add_action( 'admin_menu', 'thsn_register_customizer_menu_page' );

/**
 * Search Results settings
 */
if( !function_exists('thsn_change_wp_search_size') ){
function thsn_change_wp_search_size($query) {
	if ( $query->is_search ){ // Make sure it is a search page
		$post_type = get_query_var('post_type');
		if( !empty( get_query_var('s') ) && trim($post_type)=='' ){
			$query->query_vars['posts_per_page'] = -1;
		} else {
			if( $post_type=='post' ){
				$query->query_vars['posts_per_page'] = 8;
			} else if( in_array( $post_type, array('thsn-portfolio','thsn-service','thsn-team-member','thsn-testimonial','event_listing') ) ){
				$query->query_vars['posts_per_page'] = 9;
			} else {
				$query->query_vars['posts_per_page'] = 20;
			}
		}
	}

	return $query; // Return our modified query variables
}
}
add_filter('pre_get_posts', 'thsn_change_wp_search_size'); // Hook our custom function onto the request filter

/** Disable the scrolling effect on field validation errors
 *
 *  @link   https://wpforms.com/developers/how-to-disable-the-scrolling-effect-on-field-validation/
 */
if( !function_exists('thsn_wpforms_disable_scroll_to_error') ){
function thsn_wpforms_disable_scroll_to_error( $forms ) {
	// If scrollToError is disabled for at least one form on the page, it will be disabled for all the forms on the page.
	?>
	<script type="text/javascript">wpforms.scrollToError = function(){};</script>
	<?php
}
}
add_action( 'wpforms_wp_footer_end', 'thsn_wpforms_disable_scroll_to_error', 10, 1 );

if( !function_exists('thsn_elementor_global_options') ){
function thsn_elementor_global_options() {
	$page_id = get_option('elementor_active_kit');
	if( $page_id ){
		// Default data array
		$data = array( 'system_colors' => 
			array(
				array(
					'_id'	=> 'primary',
					'title'	=> esc_attr__( 'Primary', 'grevo' ),
					'color'	=> '#ffda2b', // global-color
				),
				array(
					'_id'	=> 'secondary',
					'title' => esc_attr__( 'Secondary', 'grevo' ),
					'color' => '#101010', // blackish-color
				),
				array(
					'_id'	=> 'text',
					'title' => esc_attr__( 'Text', 'grevo' ),
					'color' => '#666666', // global-typography - color
				),
				array(
					'_id'	=> 'accent',
					'title'	=> esc_attr__( 'Accent', 'grevo' ),
					'color'	=> '#0e47c0', // secondary-color
				),
			),
			'custom_colors'		=> array(),
			'system_typography' => array(
				array(
					'_id'						=> 'primary',
					'title'						=> esc_attr__( 'Primary', 'grevo' ),
					'typography_typography'		=> 'custom',
				),
				array(
					'_id'						=> 'secondary',
					'title'						=> esc_attr__( 'Secondary', 'grevo' ),
					'typography_typography'		=> 'custom',
				),
				array(
					'_id'						=> 'text',
					'title'						=> esc_attr__( 'Text', 'grevo' ),
					'typography_typography'		=> 'custom',
				),
				array(
					'_id'						=> 'accent',
					'title'						=> esc_attr__( 'Accent', 'grevo' ),
					'typography_typography'		=> 'custom',
				),
			),
			'custom_typography' => array(),
			'default_generic_fonts' => 'Sans-serif',
			'button_background_position' => '',
			'button_background_repeat' => '',
			'button_background_size' => '',
			'button_background_slideshow_background_size' => '',
			'button_background_slideshow_background_position' => '',
			'button_hover_background_position' => '',
			'button_hover_background_repeat' => '',
			'button_hover_background_size' => '',
			'button_hover_background_slideshow_background_size' => '',
			'button_hover_background_slideshow_background_position' => '',
			'site_name' => get_bloginfo( 'name' ),
			'site_description' => get_bloginfo( 'description' ),
			'body_background_position' => '',
			'body_background_repeat' => '',
			'body_background_size' => '',
			'body_background_slideshow_background_size' => '',
			'body_background_slideshow_background_position' => '',
			'page_title_selector' => 'h1.entry-title',
			'activeItemIndex' => 1,
			'viewport_md' => 768,
			'viewport_lg' => 1025,
		);

		// update details
		$return = update_post_meta( $page_id, '_elementor_page_settings', $data );
	}

}
}
add_action('after_switch_theme', 'thsn_elementor_global_options', 21, 2);
/**
 * Widget custom class input
 */
function thsn_widget_custom_class( $widget, $return, $instance ){

	$id		= $widget->get_field_id( 'thsn-widget-class' );
	$name	= $widget->get_field_name( 'thsn-widget-class' );
	$value	= ( !empty($instance['thsn-widget-class']) ) ? $instance['thsn-widget-class'] : '' ;

	$id_image		= $widget->get_field_id( 'thsn-widget-bg-image' );
	$name_image		= $widget->get_field_name( 'thsn-widget-bg-image' );
	$value_image	= ( !empty($instance['thsn-widget-bg-image']) ) ? $instance['thsn-widget-bg-image'] : '' ;

	?>
	<div class="thsn-widget-option thsn-widget-class-wrapper">
		<p><label for="widget-text-2-classes">Custom CSS Class:</label><input type="text" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" value="<?php echo esc_attr($value); ?>" class="widefat"></p>
	</div>

	<div class="thsn-widget-option thsn-widget-bg-image-wrapper">
		<p><label for="widget-text-2-classes">Custom Background Image for widget:</label><input type="text" name="<?php echo esc_attr($name_image); ?>" id="<?php echo esc_attr($id_image); ?>" value="<?php echo esc_attr($value_image); ?>" class="widefat"></p>
		<p class="thsn-widget-small-text">NOTE: Add image full path only. The background image size should be <code>800x600</code> pixel.</p>
	</div>

	<?php
}
add_action( 'in_widget_form', 'thsn_widget_custom_class', 10, 3 );

/**
 * Widget custom class store value
 */
function thsn_save_widget_custom_class( $instance, $new_instance, $old_instance, $object ) {

	if( isset( $new_instance['ids'] ) ){
	// ID
	$instance['ids'] = sanitize_text_field( $new_instance['ids'] );

	}

	// Widget Class

	$instance['thsn-widget-class'] = ( !empty( $new_instance['thsn-widget-class'] ) ) ? sanitize_text_field( $new_instance['thsn-widget-class'] ) : '' ;
	
	// Widget Background Image
	
	$instance['thsn-widget-bg-image'] = ( !empty( $new_instance['thsn-widget-bg-image'] ) ) ? sanitize_text_field( esc_url($new_instance['thsn-widget-bg-image']) ) : '' ;
	
	return $instance;
}
add_filter( 'widget_update_callback', 'thsn_save_widget_custom_class', 10, 4 );


/**
 * Add Class in frontend
 */
function thsn_frontend_class_event($params){
	global $wp_registered_widgets;
	
	$widget_id              = $params[0]['widget_id'];
	$widget_obj             = $wp_registered_widgets[ $widget_id ];
	$widget_num				= $widget_obj['params'][0]['number'];
	$widget_opt				= thsn_get_widget_info( $widget_obj );
	
	// Custom class
	if( !empty($widget_opt[ $widget_num ]['thsn-widget-class']) ){
		$custom_class	= trim($widget_opt[ $widget_num ]['thsn-widget-class']);

		$class						= 'class="'.$custom_class.' '; 
		$params[0]['before_widget']	= str_replace('class="', $class, $params[0]['before_widget']);

	}


	// Background image
	if( !empty($widget_opt[ $widget_num ]['thsn-widget-bg-image']) ){
		$bg_image	= trim($widget_opt[ $widget_num ]['thsn-widget-bg-image']);

		$bg_image_attr	= 'style="background-image:url(\''.$bg_image.'\');" class="'; 
		$params[0]['before_widget']	= str_replace('class="', $bg_image_attr, $params[0]['before_widget']);

	}

	return $params;
}
// add the action
add_action( "dynamic_sidebar_params", "thsn_frontend_class_event" , 10, 1);


/**
 * Get specific widget information
 */
function thsn_get_widget_info($widget_obj){
	global $post;
	$id = ( isset( $post->ID ) ? get_the_ID() : null );
	
	if( isset( $id ) && get_post_meta( $id, '_customize_sidebars' ) ){
		$custom_sidebarcheck = get_post_meta( $id, '_customize_sidebars' );
	}

	$option_name = '';
	if( isset( $widget_obj['callback'][0]->option_name ) ){
		$option_name = $widget_obj['callback'][0]->option_name;
	} else if( isset( $widget_obj['original_callback'][0]->option_name ) ){
		$option_name = $widget_obj['original_callback'][0]->option_name;
	}

	if( isset( $custom_sidebarcheck[0] ) && ( 'yes' === $custom_sidebarcheck[0] ) ){
		$widget_opt = get_option( 'widget_' . $id . '_' . substr( $option_name, 7 ) );
	} else if( $option_name ){
		$widget_opt = get_option( $option_name );
	}

	return $widget_opt;
}
/**
 * Clear Kirki font cache
 */
if( !function_exists('thsn_clear_kirki_font_cache') ){
	function thsn_clear_kirki_font_cache(){
		$thsn_theme_version	= get_option('thsn-grevo-theme-version');
		$current_theme			= wp_get_theme();
		$current_theme_version	= $current_theme->Version;
		if( $thsn_theme_version != $current_theme_version ){
			delete_option( 'kirki_downloaded_font_files' );
			delete_transient( 'kirki_remote_url_contents' );
			delete_transient( 'kirki_googlefonts_cache' );
			if( is_dir( WP_CONTENT_DIR . 'fonts' ) ){
				rmdir( WP_CONTENT_DIR . 'fonts' );
			}
		}
	}
	}
	add_action( 'init', 'thsn_clear_kirki_font_cache' );