<?php
// Default titles
$portfolio_cpt_singular_title	= esc_attr__('Portfolio','grevo');
$portfolio_cat_singular_title	= esc_attr__('Portfolio Category','grevo');
$service_cpt_singular_title	= esc_attr__('Service','grevo');
$service_cat_singular_title	= esc_attr__('Service Category','grevo');
$team_cpt_singular_title	= esc_attr__('Team Member','grevo');
$team_group_singular_title	= esc_attr__('Team Group','grevo');
$testimonial_cpt_singular_title		= esc_attr__('Testimonial','grevo');
$testimonial_cat_singular_title	= esc_attr__('Testimonial Category','grevo');
if( class_exists('Kirki') ){
	// Portfolio
	$portfolio_cpt_singular_title2	= Kirki::get_option( 'portfolio-cpt-singular-title' );
	$portfolio_cpt_singular_title	= ( !empty($portfolio_cpt_singular_title2) ) ? $portfolio_cpt_singular_title2 : $portfolio_cpt_singular_title ;
	// Portfolio Category
	$portfolio_cat_singular_title2	= Kirki::get_option( 'portfolio-cat-singular-title' );
	$portfolio_cat_singular_title	= ( !empty($portfolio_cat_singular_title2) ) ? $portfolio_cat_singular_title2 : $portfolio_cat_singular_title ;
	// Service
	$service_cpt_singular_title2	= Kirki::get_option( 'service-cpt-singular-title' );
	$service_cpt_singular_title	= ( !empty($service_cpt_singular_title2) ) ? $service_cpt_singular_title2 : $service_cpt_singular_title ;
	// Service Category
	$service_cat_singular_title2	= Kirki::get_option( 'service-cat-singular-title' );
	$service_cat_singular_title	= ( !empty($service_cat_singular_title2) ) ? $service_cat_singular_title2 : $service_cat_singular_title ;
	// Team
	$team_cpt_singular_title2	= Kirki::get_option( 'team-cpt-singular-title' );
	$team_cpt_singular_title	= ( !empty($team_cpt_singular_title2) ) ? $team_cpt_singular_title2 : $team_cpt_singular_title ;
	// Team Group
	$team_group_singular_title2	= Kirki::get_option( 'team-group-singular-title' );
	$team_group_singular_title	= ( !empty($team_group_singular_title2) ) ? $team_group_singular_title2 : $team_group_singular_title ;
	// Testimonial
	$testimonial_cpt_singular_title2	= Kirki::get_option( 'testimonial-cpt-singular-title' );
	$testimonial_cpt_singular_title	= ( !empty($testimonial_cpt_singular_title2) ) ? $testimonial_cpt_singular_title2 : $testimonial_cpt_singular_title ;
	// Testimonial Category
	$testimonial_cat_singular_title2	= Kirki::get_option( 'testimonial-cat-singular-title' );
	$testimonial_cat_singular_title	= ( !empty($testimonial_cat_singular_title2) ) ? $testimonial_cat_singular_title2 : $testimonial_cat_singular_title ;
}
$pre_color_list = array(
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
	'transparent'		=> get_template_directory_uri() . '/includes/images/precolor-transparent.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'light'				=> get_template_directory_uri() . '/includes/images/precolor-light.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'custom'			=> get_template_directory_uri() . '/includes/images/precolor-custom.png',
);
$pre_color_with_gradient_list = array(
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
	'gradientcolor'		=> get_template_directory_uri() . '/includes/images/precolor-gradientcolor.png',
	'transparent'		=> get_template_directory_uri() . '/includes/images/precolor-transparent.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'light'				=> get_template_directory_uri() . '/includes/images/precolor-light.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'custom'			=> get_template_directory_uri() . '/includes/images/precolor-custom.png',
);
$pre_two_color_list = array(
	''					=> get_template_directory_uri() . '/includes/images/precolor-default.png',
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
);
$pre_text_color_list = array(
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
	'globalcolor'		=> get_template_directory_uri() . '/includes/images/precolor-globalcolor.png',
	'secondarycolor'	=> get_template_directory_uri() . '/includes/images/precolor-secondarycolor.png',
);
$pre_text_color_2_list = array(
	'white'				=> get_template_directory_uri() . '/includes/images/precolor-white.png',
	'blackish'			=> get_template_directory_uri() . '/includes/images/precolor-blackish.png',
);
$column_list = array(
	'1'	=> get_template_directory_uri() . '/includes/images/column-1.png',
	'2'	=> get_template_directory_uri() . '/includes/images/column-2.png',
	'3'	=> get_template_directory_uri() . '/includes/images/column-3.png',
	'4'	=> get_template_directory_uri() . '/includes/images/column-4.png',
	'5'	=> get_template_directory_uri() . '/includes/images/column-5.png',
	'6'	=> get_template_directory_uri() . '/includes/images/column-6.png',
);
// Total Header Styles
$header_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/header-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/header-style-2.jpg',
	'3'	=> get_template_directory_uri() . '/includes/images/header-style-3.jpg',
	'4'	=> get_template_directory_uri() . '/includes/images/header-style-4.jpg',
);
// Total Single Portfolio Styles
$portfolio_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/portfolio-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/portfolio-single-style-2.jpg',
);
// Total Single Service Styles
$service_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/service-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/service-single-style-2.jpg',
);
// Total Single Portfolio Styles
$team_single_style_array = array(
	'1'	=> get_template_directory_uri() . '/includes/images/team-single-style-1.jpg',
	'2'	=> get_template_directory_uri() . '/includes/images/team-single-style-2.jpg',
);
// Social links
$social_options_array = array();
if( function_exists('thsn_social_links_list') ){
	$social_list = thsn_social_links_list();
	foreach( $social_list as $social ){
		$social_options_array[] = array(
			'type'			=> 'text',
			'settings'		=> esc_attr( $social['id'] ),
			'label'			=> esc_attr( $social['label'] ),
			'description'	=> esc_attr__( 'Write Social URL.', 'grevo' ),
			'default'		=> '',
		);
	}
}
$footer_col_width_array = array(
	'hide'	=> esc_attr__( 'Hide this column', 'grevo' ),
	'1'		=> esc_attr__( '1%', 'grevo' ),
	'2'		=> esc_attr__( '2%', 'grevo' ),
	'3'		=> esc_attr__( '3%', 'grevo' ),
	'4'		=> esc_attr__( '4%', 'grevo' ),
	'5'		=> esc_attr__( '5%', 'grevo' ),
	'6'		=> esc_attr__( '6%', 'grevo' ),
	'7'		=> esc_attr__( '7%', 'grevo' ),
	'8'		=> esc_attr__( '8%', 'grevo' ),
	'9'		=> esc_attr__( '9%', 'grevo' ),
	'10'	=> esc_attr__( '10%', 'grevo' ),
	'11'	=> esc_attr__( '11%', 'grevo' ),
	'12'	=> esc_attr__( '12%', 'grevo' ),
	'13'	=> esc_attr__( '13%', 'grevo' ),
	'14'	=> esc_attr__( '14%', 'grevo' ),
	'15'	=> esc_attr__( '15%', 'grevo' ),
	'16'	=> esc_attr__( '16%', 'grevo' ),
	'17'	=> esc_attr__( '17%', 'grevo' ),
	'18'	=> esc_attr__( '18%', 'grevo' ),
	'19'	=> esc_attr__( '19%', 'grevo' ),
	'20'	=> esc_attr__( '20%', 'grevo' ),
	'21'	=> esc_attr__( '21%', 'grevo' ),
	'22'	=> esc_attr__( '22%', 'grevo' ),
	'23'	=> esc_attr__( '23%', 'grevo' ),
	'24'	=> esc_attr__( '24%', 'grevo' ),
	'25'	=> esc_attr__( '25%', 'grevo' ),
	'26'	=> esc_attr__( '26%', 'grevo' ),
	'27'	=> esc_attr__( '27%', 'grevo' ),
	'28'	=> esc_attr__( '28%', 'grevo' ),
	'29'	=> esc_attr__( '29%', 'grevo' ),
	'30'	=> esc_attr__( '30%', 'grevo' ),
	'31'	=> esc_attr__( '31%', 'grevo' ),
	'32'	=> esc_attr__( '32%', 'grevo' ),
	'33'	=> esc_attr__( '33%', 'grevo' ),
	'34'	=> esc_attr__( '34%', 'grevo' ),
	'35'	=> esc_attr__( '35%', 'grevo' ),
	'36'	=> esc_attr__( '36%', 'grevo' ),
	'37'	=> esc_attr__( '37%', 'grevo' ),
	'38'	=> esc_attr__( '38%', 'grevo' ),
	'39'	=> esc_attr__( '39%', 'grevo' ),
	'40'	=> esc_attr__( '40%', 'grevo' ),
	'41'	=> esc_attr__( '41%', 'grevo' ),
	'42'	=> esc_attr__( '42%', 'grevo' ),
	'43'	=> esc_attr__( '43%', 'grevo' ),
	'44'	=> esc_attr__( '44%', 'grevo' ),
	'45'	=> esc_attr__( '45%', 'grevo' ),
	'46'	=> esc_attr__( '46%', 'grevo' ),
	'47'	=> esc_attr__( '47%', 'grevo' ),
	'48'	=> esc_attr__( '48%', 'grevo' ),
	'49'	=> esc_attr__( '49%', 'grevo' ),
	'50'	=> esc_attr__( '50%', 'grevo' ),
	'51'	=> esc_attr__( '51%', 'grevo' ),
	'52'	=> esc_attr__( '52%', 'grevo' ),
	'53'	=> esc_attr__( '53%', 'grevo' ),
	'54'	=> esc_attr__( '54%', 'grevo' ),
	'55'	=> esc_attr__( '55%', 'grevo' ),
	'56'	=> esc_attr__( '56%', 'grevo' ),
	'57'	=> esc_attr__( '57%', 'grevo' ),
	'58'	=> esc_attr__( '58%', 'grevo' ),
	'59'	=> esc_attr__( '59%', 'grevo' ),
	'60'	=> esc_attr__( '60%', 'grevo' ),
	'61'	=> esc_attr__( '61%', 'grevo' ),
	'62'	=> esc_attr__( '62%', 'grevo' ),
	'63'	=> esc_attr__( '63%', 'grevo' ),
	'64'	=> esc_attr__( '64%', 'grevo' ),
	'65'	=> esc_attr__( '65%', 'grevo' ),
	'66'	=> esc_attr__( '66%', 'grevo' ),
	'67'	=> esc_attr__( '67%', 'grevo' ),
	'68'	=> esc_attr__( '68%', 'grevo' ),
	'69'	=> esc_attr__( '69%', 'grevo' ),
	'70'	=> esc_attr__( '70%', 'grevo' ),
	'71'	=> esc_attr__( '71%', 'grevo' ),
	'72'	=> esc_attr__( '72%', 'grevo' ),
	'73'	=> esc_attr__( '73%', 'grevo' ),
	'74'	=> esc_attr__( '74%', 'grevo' ),
	'75'	=> esc_attr__( '75%', 'grevo' ),
	'76'	=> esc_attr__( '76%', 'grevo' ),
	'77'	=> esc_attr__( '77%', 'grevo' ),
	'78'	=> esc_attr__( '78%', 'grevo' ),
	'79'	=> esc_attr__( '79%', 'grevo' ),
	'80'	=> esc_attr__( '80%', 'grevo' ),
	'81'	=> esc_attr__( '81%', 'grevo' ),
	'82'	=> esc_attr__( '82%', 'grevo' ),
	'83'	=> esc_attr__( '83%', 'grevo' ),
	'84'	=> esc_attr__( '84%', 'grevo' ),
	'85'	=> esc_attr__( '85%', 'grevo' ),
	'86'	=> esc_attr__( '86%', 'grevo' ),
	'87'	=> esc_attr__( '87%', 'grevo' ),
	'88'	=> esc_attr__( '88%', 'grevo' ),
	'89'	=> esc_attr__( '89%', 'grevo' ),
	'90'	=> esc_attr__( '90%', 'grevo' ),
	'91'	=> esc_attr__( '91%', 'grevo' ),
	'92'	=> esc_attr__( '92%', 'grevo' ),
	'93'	=> esc_attr__( '93%', 'grevo' ),
	'94'	=> esc_attr__( '94%', 'grevo' ),
	'95'	=> esc_attr__( '95%', 'grevo' ),
	'96'	=> esc_attr__( '96%', 'grevo' ),
	'97'	=> esc_attr__( '97%', 'grevo' ),
	'98'	=> esc_attr__( '98%', 'grevo' ),
	'99'	=> esc_attr__( '99%', 'grevo' ),
	'100'	=> esc_attr__( '100%', 'grevo' ),
);

$blog_styles = thsn_element_template_list('blog', 'customizer');
unset($blog_styles['classic'], $blog_styles['4']);

/*** Options array ***/
$kirki_options_array = array(
	// General Settings
	'general_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'General Options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'color',
				'settings'		=> 'global-color',
				'label'			=> esc_attr__( 'Global Color', 'grevo' ),
				'description'	=> esc_attr__( 'This color will be globally applied to most of elements parts and special texts', 'grevo' ),
				'default'		=> '#8cc63f',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'secondary-color',
				'label'			=> esc_attr__( 'Secondary Color', 'grevo' ),
				'description'	=> esc_attr__( 'This color will be used on some elements. Sometimes with Global Color. This should match with Global Color to look good.', 'grevo' ),
				'default'		=> '#131419',
			),
			array(
				'type'		=> 'multicolor',
				'settings'	=> 'gradient-color',
				'label'		=> esc_attr__( 'Gradient Color', 'grevo' ),
				'choices'		=> array(
					'first'		=> esc_attr__( 'Starting Color', 'grevo' ),
					'last'		=> esc_attr__( 'Ending Color', 'grevo' ),
				),
				'default'	=> array(
				  'first'		=> '#8cc63f',
				  'last'		=> '#8cc63f',
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'logo',
				'label'				=> esc_attr__( 'Logo', 'grevo' ),
				'description'		=> esc_attr__( 'Main logo', 'grevo' ),
				'default'			=> get_template_directory_uri() . '/images/logo.png',
				'partial_refresh'	=> array(
					'logo'				=> array(
						'selector'			=> '.site-title',
						'render_callback'	=> function() {
							return thsn_logo( 'yes' );
						},
					)
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'logo-height',
				'label'			=> esc_attr__( 'Logo Max Height', 'grevo' ),
				'default'		=> 45,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'image',
				'settings'		=> 'sticky-logo',
				'label'			=> esc_attr__( 'Sticky Logo', 'grevo' ),
				'description'	=> esc_attr__( 'Sticky logo', 'grevo' ),
				'default'		=> '',
				'active_callback'=> array( array(
					'setting' => 'sticky-header',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'sticky-logo-height',
				'label'			=> esc_attr__( 'Sticky Logo Max Height', 'grevo' ),
				'default'		=> 45,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
				'active_callback'=> array( array(
					'setting' => 'sticky-header',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'image',
				'settings'		=> 'responsive-logo',
				'label'			=> esc_attr__( 'Responsive Logo', 'grevo' ),
				'description'	=> esc_attr__( 'This logo appear in small devices like mobile/tablet etc', 'grevo' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'responsive-logo-height',
				'label'			=> esc_attr__( 'Responsive Logo Max Height', 'grevo' ),
				'default'		=> 45,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
			),
			array(
				'type'		=> 'multicolor',
				'settings'	=> 'link-color',
				'label'		=> esc_attr__( 'Link Color', 'grevo' ),
				'choices'		=> array(
					'normal'	=> esc_attr__( 'Normal Color', 'grevo' ),
					'hover'		=> esc_attr__( 'Mouse-Over (Hover) Color', 'grevo' ),
				),
				'default'	=> array(
					'normal'	=> '#131419',
					'hover'		=> '#8cc63f',
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'preloader',
				'label'			=> esc_attr__( 'Show Preloader?', 'grevo' ),
				'description'	=> esc_attr__( 'Show or hide preloader', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'preloader-image',
				'label'			=> esc_html__( 'Select preloader image', 'grevo' ),
				'default'		=> '1',
				'choices'		=> array(
					'1'   => get_template_directory_uri() . '/images/loader1.svg',
					'2'   => get_template_directory_uri() . '/images/loader2.svg',
					'3'   => get_template_directory_uri() . '/images/loader3.svg',
					'4'   => get_template_directory_uri() . '/images/loader4.svg',
					'5'   => get_template_directory_uri() . '/images/loader5.svg',
					'6'   => get_template_directory_uri() . '/images/loader6.svg',
					'7'   => get_template_directory_uri() . '/images/loader7.svg',
					'8'   => get_template_directory_uri() . '/images/loader8.svg',
					'9'   => get_template_directory_uri() . '/images/loader9.svg',
				),
				'active_callback'=> array( array(
					'setting' => 'preloader',
					'operator' => '==',
					'value' => '1',
				) ),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'responsive-breakpoint',
				'label'			=> esc_attr__( 'Responsive Breakpoint', 'grevo' ),
				'description'	=> esc_attr__( 'Select screen size to make the menu burger menu (responsive menu) below the selected screen size and also other settings too. Preferred Sizes: 1200, 1024, 992 and 768', 'grevo' ),
				'default'		=> 1200,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 2000,
					'step'			=> 1,
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-page',
				'label'		=> esc_html__( 'Page Sidebar', 'grevo' ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// One Pgae
			array(
				'type'        => 'custom',
				'settings'    => 'one_page_heading',
				'default'     => '<div class="themesion-option-heading"><h2>' . esc_html__( 'One Page Site', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Enable this for one-page website. ', 'grevo' ) . '</span></div>',
			),
			array(
				'type'        => 'switch',
				'settings'    => 'onepage',
				'label'       => esc_attr__( 'Enable one-page website?', 'grevo' ),
				'description' => esc_attr__( 'This will add support for one-page site.', 'grevo' ),
				'default'     => '0',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			// Advanced Settings
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-advanced-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Advanced Settings', 'grevo' ) . '</h2> <span>' . esc_html__( 'Special advanced options', 'grevo' ) . '</span></div>',
			),
			array(
				'type'        => 'switch',
				'settings'    => 'min',
				'label'       => esc_attr__( 'Load Minified CSS and JS Files?', 'grevo' ),
				'description' => esc_attr__( 'Load minified files for CSS and JS code files. Select YES to reduce page load time.', 'grevo' ),
				'default'     => '1',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'white-color',
				'label'			=> esc_attr__( 'White Color', 'grevo' ),
				'description'	=> esc_attr__( 'This is default white color for text.', 'grevo' ),
				'default'		=> '#ffffff',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'light-bg-color',
				'label'			=> esc_attr__( 'Light Background Color', 'grevo' ),
				'description'	=> esc_attr__( 'This is default grey background color.', 'grevo' ),
				'default'		=> '#eff3f5',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'blackish-color',
				'label'			=> esc_attr__( 'Blackish Text Color', 'grevo' ),
				'description'	=> esc_attr__( 'This is default blackish color for text.', 'grevo' ),
				'default'		=> '#101010',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'blackish-bg-color',
				'label'			=> esc_attr__( 'Blackish Background Color', 'grevo' ),
				'description'	=> esc_attr__( 'This is default blackish background color.', 'grevo' ),
				'default'		=> '#101010',
			),
		)
	),
	// Typography Settings
	'typography_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Typography Options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'typography',
				'settings'		=> 'global-typography',
				'label'			=> esc_attr__( 'Global Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array (
					'font-family'		=> 'Nunito Sans',
					'variant'			=> 'regular',
					'font-size'			=> '16px',
					'line-height'		=> '1.7',
					'letter-spacing'	=> '',
					'color'				=> '#60626d',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				  ),
				'priority'			=> 10,
				'thsn-output'		=> 'body',
				'thsn-all-variants'	=> true,
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h1-typography',
				'label'			=> esc_attr__( 'H1 Typography', 'grevo' ),
				'tooltip'     => esc_attr__( 'This is tooltip', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '40px',
					'line-height'		=> '44px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> '',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> 'h1',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h2-typography',
				'label'			=> esc_attr__( 'H2 Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '34px',
					'line-height'		=> '38px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> '',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> 'h2',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h3-typography',
				'label'			=> esc_attr__( 'H3 Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '30px',
					'line-height'		=> '34px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> '',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> 'h3',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h4-typography',
				'label'			=> esc_attr__( 'H4 Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '26px',
					'line-height'		=> '30px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> '',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> 'h4',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h5-typography',
				'label'			=> esc_attr__( 'H5 Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '22px',
					'line-height'		=> '26px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> '',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> 'h5',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'h6-typography',
				'label'			=> esc_attr__( 'H6 Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '22px',
					'line-height'		=> '26px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> '',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> 'h6',
			),
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Special Heading Typography', 'grevo' ) . '</h2> <span>' . esc_html__( 'Heading typography options', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'heading-typography',
				'label'			=> esc_attr__( 'Heading Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '40px',
					'line-height'		=> '48px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> '.thsn-heading-subheading .thsn-element-title',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'subheading-typography',
				'label'			=> esc_attr__( 'Sub-heading Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito Sans',
					'variant'			=> '700',
					'font-size'			=> '13px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '0.8px',
					'color'				=> '#101010',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> '.thsn-heading-subheading .thsn-element-subtitle',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'content-typography',
				'label'			=> esc_attr__( 'Content Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito Sans',
					'variant'			=> 'regular',
					'font-size'			=> '16px',
					'line-height'		=> '1.7',
					'letter-spacing'	=> '0px',
					'color'				=> '#60626d',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> '.thsn-ihbox.thsn-ihbox-style-hsbox .thsn-ihbox-content',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'widget-heading-typography',
				'label'			=> esc_attr__( 'Widget Heading Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '22px',
					'line-height'		=> '26px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> '.thsn-footer-copyright-box h3,.themesion-sidebar .widget_search .wp-block-search__label, .themesion-sidebar .widget_block .wp-block-group h3, .widget.widget_block .wp-block-group > h2, .widget-title, .thsn-footer-copyright-box h3',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'buttons-typography',
				'label'			=> esc_attr__( 'Button Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '13px',
					'line-height'		=> '18px',
					'letter-spacing'	=> '0px',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'thsn-output'	=> '.thsn-search-results-back-global-btn a, .thsn-search-results-load-btn a, .thsn-read-more-link a, .thsn-service-btn a, .thsn-header-button, .thsn-header-button2, .woocommerce ul.products li.product .onsale, .woocommerce div.product .woocommerce-tabs ul.tabs li a, .elementor-widget-button .elementor-button, .thsn-ptable-btn a, .thsn-service-btn, .thsn-ihbox-btn, .woocommerce .woocommerce-message .button, .woocommerce div.product form.cart .button, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, button, html input[type=button], input[type=reset], input[type=submit], .thsn-service-button',
			),
			// Extra Load Fonts Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'css-only-custom-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'CSS only Typography', 'grevo' ) . '</h2> <span>' . esc_html__( 'This will not apply to any font style but this font will be loaded so we can use anywhere.', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-1-typography',
				'label'			=> esc_attr__( 'First Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> 'regular',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'thsn-output'	=> '.site-content .thsn_widget_list_all_posts ul > li a,.themesion-sidebar .widget ul a,.thsn-portfolio-lines-wrapper .thsn-portfolio-line-title,.themesion-ele-fid-style-5 .thsn-fid-title, .thsn-ourhistory .label, .site-header .thsn-slider-area .hermes .tp-bullet:after,.thsn-pricing-table-box .themesion-ptable-price-w, .elementor-accordion .elementor-tab-title a, .thsn-service-style-1 .themesion-box-content:after, .thsn-blog-classic blockquote:not(.wp-block-quote):not(.has-text-color), #thsn-count-down .content_countdown .time_left,.thsn-ihbox-style-2 .thsn-ihbox-icon-type-text,.themesion-ele-fid-style-4 .thsn-fid-title, .single-post ul.thsn-list-box li,.thsn-team-single-style-1 .thsn-team-download,.elementor-widget-progress, .thsn-header-style-4 .thsn-label, .thsn-header-style-3 .thsn-social-label, .thsn-header-style-3  .thsn-social-links,.error404 a.thsn-home-back, .post-navigation .nav-links .nav-title, .post-navigation .nav-links .nav-title',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-2-typography',
				'label'			=> esc_attr__( 'Second Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '500',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'thsn-output'	=> '.thsn-blog-style-1 .thsn-meta-date-wrapper, .thsn-blog-style-2 .thsn-meta-date-wrapper, .themesion-ele-fid-style-2 .thsn-fid-title,.thsn-testimonial-style-1 .themesion-box-desc,.thsn-testimonial-style-2 .themesion-box-desc,.thsn-text-style-1 .elementor-widget-container, .single-service-contact-inner, #wpsl-search-wrap div label, #wpsl-stores ul li .wpsl-store-location p strong',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'css-only-3-typography',
				'label'			=> esc_attr__( 'Third Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito Sans',
					'variant'			=> 'regular',
					'font-style'		=> 'normal',
					'font-backup'		=> '',
				),
				'thsn-output'	=> '#thsn-count-down .countdown .time_description, .thsn-service-style-2 .thsn-service-cat h4, .thsn-service-style-3 .thsn-service-cat h4, .thsn-ihbox-style-11 .thsn-element-title,.single-post blockquote cite em',
			),
		)
	),
	// Pre-Header Options
	'preheader_options'	=> array(
		'section_settings'	=> array(
			'title'				=> esc_attr__( 'Pre-Header Options', 'grevo' ),
			'panel'				=> 'grevo_base_options',
			'priority'			=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'preheader-enable',
				'label'			=> esc_attr__( 'Show or hide Pre-header', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'			=> esc_attr__( 'Show', 'grevo' ),
					'off'			=> esc_attr__( 'Hide', 'grevo' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'preheader-text-color',
				'label'				=> esc_attr__( 'Select pre-header text color', 'grevo' ),
				'default'			=> 'white',
				'choices'			=> $pre_text_color_list,
				'active_callback'	=> array(
					array(
						'setting'		=> 'preheader-enable',
						'operator'		=> '==',
						'value'			=> '1',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'preheader-bgcolor',
				'label'				=> esc_html__( 'Select pre-header background color', 'grevo' ),
				'default'			=> 'blackish',
				'choices'			=> $pre_color_list,
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'preheader-bgcolor-custom',
				'label'			=> esc_attr__( 'Select pre-header background custom color', 'grevo' ),
				'description'	=> esc_attr__( 'Select custom color for pre-header background', 'grevo' ),
				'default'		=> '#ff5e15',
				'active_callback'=> array(
					array(
						'setting'	=> 'preheader-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					),
					array(
						'setting'			=> 'preheader-enable',
						'operator'			=> '==',
						'value'				=> '1',
					)
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'preheader-responsive',
				'label'			=> esc_attr__( 'Hide in screen size', 'grevo' ),
				'description'	=> esc_attr__( 'Select screen size to hide this pre-header below the selected screen size. Preferred Sizes: 1200, 1024, 992 and 768', 'grevo' ),
				'default'		=> 1200,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 2000,
					'step'			=> 1,
				),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'preheader-content-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Preheader content', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Manage preheader content from here', 'grevo' ) . '</span></div>',
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'preheader-left',
				'label'			=> esc_attr__( 'Pre-header Left Content', 'grevo' ),
				'default'		=> thsn_esc_kses('<i class="thsn-base-icon-marker"></i> Los Angeles Gournadi, 1230  Bariasl'),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'preheader-left'		=> array(
						'selector'			=> '.thsn-pre-header-left',
						'render_callback'	=> function() {
							return get_theme_mod('preheader-left');
						},
					)
				),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'preheader-right',
				'label'			=> esc_attr__( 'Pre-header Right Content', 'grevo' ),
				'default'		=> thsn_esc_kses('<ul class="thsn-contact-info"><li><i class="thsn-base-icon-contact"></i> Make a call  : +1 (212) 255-5511</li><li>[thsn-social-links]</li></ul>'),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
				'partial_refresh'	=> array(
					'preheader-right'		=> array(
						'selector'			=> '.thsn-pre-header-right',
						'render_callback'	=> function() {
							return get_theme_mod('preheader-right');
						},
					)
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'preheader-search',
				'label'			=> esc_attr__( 'Show Search Icon in Pre-header Right Area?', 'grevo' ),
				'description'	=> esc_attr__( 'Select YES to show search icon in pre-header right side.', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'preheader-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
		),
	),
	// Header Options
	'header_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Header Options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'header-style',
				'label'		=> esc_html__( 'Header Style', 'grevo' ),
				'description'	=> '<div class="thsn-alert-message">'.esc_html__( 'NOTE: This will also change other options (like background color, menu color, logo etc) to set it with this header.', 'grevo' ).'</div>',
				'default'	=> '1',
				'choices'		=> $header_style_array,
			),

			// - Infostack contents
			// 1st Box
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-box1-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Header 1st Box Contents', 'grevo' ) . '</h2> <span>' . esc_html__( 'Add or modify content for 1st box in header area.', 'grevo' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),	
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'			=> 'themesion_icon_picker',
				'settings'		=> 'header-box1-icon',
				'label'			=> esc_attr__( '1st box - Icon', 'grevo' ),
				'description'	=> esc_attr__( 'Select icon for 1st box', 'grevo' ),
				'default'		=> esc_attr('thsn-grevo-icon thsn-grevo-icon-email;fa fa-map-marker;sgicon sgicon-Pointer'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box1-title',
				'label'		=> esc_attr__( '1st Box - Title', 'grevo' ),
				'default'	=> esc_attr('Call us for any question'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-box1-title'		=> array(
						'selector'			=> '.thsn-header-box-1 .thsn-header-box-title',
						'render_callback'	=> function() {
							return get_theme_mod('header-box1-title');
						},
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box1-content',
				'label'		=> esc_attr__( '1st Box - Content', 'grevo' ),
				'default'	=> esc_attr('(+00)888.666.88'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),	
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),				
					)
				),
			),
			array(
				'type'		=> 'link',
				'settings'	=> 'header-box1-link',
				'label'		=> esc_attr__( '1st Box - Link', 'grevo' ),
				'default'	=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			// 2nd Box
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-box2-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Header 2nd Box Contents', 'grevo' ) . '</h2> <span>' . esc_html__( 'Add or modify content for 2nd box in header area.', 'grevo' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'			=> 'themesion_icon_picker',
				'settings'		=> 'header-box2-icon',
				'label'			=> esc_attr__( '2nd box - Icon', 'grevo' ),
				'description'	=> esc_attr__( 'Select icon for 2nd box', 'grevo' ),
				'default'		=> esc_attr('thsn-grevo-icon thsn-grevo-icon-mail;fa fa-info-circle;sgicon sgicon-Mail;'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box2-title',
				'label'		=> esc_attr__( '2nd Box - Title', 'grevo' ),
				'default'	=> esc_attr('Request on'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-box2-title'		=> array(
						'selector'			=> '.thsn-header-box-2 .thsn-header-box-title',
						'render_callback'	=> function() {
							return get_theme_mod('header-box2-title');
						},
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box2-content',
				'label'		=> esc_attr__( '2nd Box - Content', 'grevo' ),
				'default'	=> esc_attr('Get Appointment'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'		=> 'link',
				'settings'	=> 'header-box2-link',
				'label'		=> esc_attr__( '2nd Box - Link', 'grevo' ),
				'default'	=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			// 3rd Box
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-box3-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Header 3rd Box Contents', 'grevo' ) . '</h2> <span>' . esc_html__( 'Add or modify content for 3rd box in header area.', 'grevo' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
					)
				),
			),
			array(
				'type'			=> 'themesion_icon_picker',
				'settings'		=> 'header-box3-icon',
				'label'			=> esc_attr__( '3rd box - Icon', 'grevo' ),
				'description'	=> esc_attr__( 'Select icon for 3rd box', 'grevo' ),
				'default'		=> esc_attr('thsn-grevo-icon thsn-grevo-icon-;fa fa-info-circle;sgicon sgicon-Phone2;'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box3-title',
				'label'		=> esc_attr__( '3rd Box - Title', 'grevo' ),
				'default'	=> esc_attr('000 8888 999'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-box3-title'		=> array(
						'selector'			=> '.thsn-header-box-3 .thsn-header-box-title',
						'render_callback'	=> function() {
							return get_theme_mod('header-box3-title');
						},
					)
				),
			),
			array(
				'type'		=> 'text',
				'settings'	=> 'header-box3-content',
				'label'		=> esc_attr__( '3rd Box - Content', 'grevo' ),
				'default'	=> esc_attr('Free Call'),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
					)
				),
			),
			array(
				'type'		=> 'link',
				'settings'	=> 'header-box3-link',
				'label'		=> esc_attr__( '3rd Box - Link', 'grevo' ),
				'default'	=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
					)
				),
			),

			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-box-typography',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Header Box Typography', 'grevo' ) . '</h2> <span>' . esc_html__( 'Select or change header box typography', 'grevo' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'header-box-title-typography',
				'label'			=> esc_attr__( 'Header Typography - Box Title', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Barlow',
					'variant'			=> '800',
					'font-size'			=> '17px',
					'line-height'		=> '27px',
					'letter-spacing'	=> '0px',
					'color'				=> '#0c121d',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'thsn-output'	=> '.thsn-header-box-title',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'header-box-content-typography',
				'label'			=> esc_attr__( 'Header Typography - Box Content', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Barlow',
					'variant'			=> '700',
					'font-size'			=> '15px',
					'line-height'		=> '25px',
					'letter-spacing'	=> '1px',
					'color'				=> '#b0b6bf',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'thsn-output'	=> '.thsn-header-box-content',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),

			// Header button
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-button-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Header Button', 'grevo' ) . '</h2> <span>' . esc_html__( 'Set header button title and link', 'grevo' ) . '</span></div>',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
					)
				),
			),

			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-text',
				'label'				=> esc_attr__( 'Header Button Text (1st line)', 'grevo' ),
				'default'		=> esc_attr__( 'Have any Question ?', 'grevo' ),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-btn-text'	=> array(
						'selector'			=> '.thsn-header-button',
						'render_callback'	=> function() {
							return thsn_header_button( array('inneronly'=>'yes') );
						},
					)
				),
			),

			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn-url',
				'label'				=> esc_attr__( 'Header Button Link (URL)', 'grevo' ),
				'default'			=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '2',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),

			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-button2-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Header Button Second', 'grevo' ) . '</h2> <span>' . esc_html__( 'Set header button title and link', 'grevo' ) . '</span></div>',
				'active_callback'=> array(
					array(									
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
					)
				),
			),

			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn2-text',
				'label'				=> esc_attr__( 'Header Button Text', 'grevo' ),
				'default'		=> esc_attr__( 'Have any Question ?', 'grevo' ),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
					)
				),
				'partial_refresh'	=> array(
					'header-btn-text'	=> array(
						'selector'			=> '.thsn-header-button',
						'render_callback'	=> function() {
							return thsn_header_button( array('inneronly'=>'yes') );
						},
					)
				),
			),
			array(
				'type'				=> 'text',
				'settings'			=> 'header-btn2-url',
				'label'				=> esc_attr__( 'Header Button Link (URL)', 'grevo' ),
				'default'			=> '',
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3'
						),
					)
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-header-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'General Options', 'grevo' ) . '</h2> <span>' . esc_html__( 'Common options that apply to all header styles', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'header-height',
				'label'			=> esc_attr__( 'Header Height (in pixel)', 'grevo' ),
				'description'	=> esc_attr__( 'Select header height', 'grevo' ),
				'default'		=> 115,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'header-bgcolor',
				'label'				=> esc_html__( 'Select header background color', 'grevo' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'header-background-color',
				'label'			=> esc_attr__( 'Header Background Color', 'grevo' ),
				'description'	=> esc_attr__( 'Select custom color for header background', 'grevo' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'header-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'menu-bgcolor',
				'label'				=> esc_html__( 'Select menu area background color', 'grevo' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '3',
						),
						array(
							'setting'	=> 'header-style',
							'operator'	=> '==',
							'value'		=> '4',
						),
					)
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'menu-background-color',
				'label'			=> esc_attr__( 'Menu Area Background Color', 'grevo' ),
				'description'	=> esc_attr__( 'Select custom color for Menu area background', 'grevo' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'menu-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			// Search in Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-search-header-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Search in Header', 'grevo' ) . '</h2> <span>' . esc_html__( 'Options for search in header area', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'header-search',
				'label'			=> esc_attr__( 'Show Search Icon in Header Area?', 'grevo' ),
				'description'	=> esc_attr__( 'Select YES to show search icon in header area.', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),

			// Sticky Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-sticky-header-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Sticky Header Options', 'grevo' ) . '</h2> <span>' . esc_html__( 'Options for sticky header area', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'sticky-header',
				'label'			=> esc_attr__( 'Sticky Header on Scroll?', 'grevo' ),
				'description'	=> esc_attr__( 'Select YES to make header sticky on scroll.', 'grevo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'sticky-header-height',
				'label'			=> esc_attr__( 'Sticky Area Height (in pixel)', 'grevo' ),
				'description'	=> esc_attr__( 'Select Area height for sticky header', 'grevo' ),
				'default'		=> 90,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 300,
					'step'			=> 1,
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'sticky-header',
							'operator'	=> '==',
							'value'		=> '1',
						),
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'sticky-header-bgcolor',
				'label'				=> esc_html__( 'Sticky Area Background Color', 'grevo' ),
				'default'			=> 'white',
				'choices'			=> $pre_color_list,
				'active_callback'	=> array(
					array(
						'setting'	=> 'sticky-header',
						'operator'	=> '==',
						'value'		=> '1',
					)
				),
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'sticky-header-background-color',
				'label'			=> esc_attr__( 'Sticky Header Background Custom Color', 'grevo' ),
				'description'	=> esc_attr__( 'Select custom color for sticky header background', 'grevo' ),
				'default'		=> '#ffffff',
				'active_callback'=> array(
					array(
						'setting'	=> 'sticky-header',
						'operator'	=> '==',
						'value'		=> '1',
					),
					array(
						'setting'	=> 'sticky-header-bgcolor',
						'operator'	=> '==',
						'value'		=> 'custom',
					)
				),
			),
			// Responsive Header
			array(
				'type'			=> 'custom',
				'settings'		=> 'responsive-header-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Responsive Header Options', 'grevo' ) . '</h2> <span>' . esc_html__( 'Options for responsive (mobile or tablet mode) header area', 'grevo' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'responsive-header-bgcolor',
				'label'				=> esc_html__( 'Select header background color', 'grevo' ),
				'default'			=> 'white',
				'choices'			=> $pre_two_color_list,
			),
		),
	),
	// Menu Options
	'menu_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Menu Options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Main Menu Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'main-menu-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Main Menu Options', 'grevo' ) . '</h2> <span>' . esc_html__( 'Set Main Menu font settings', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'main-menu-typography',
				'label'			=> esc_attr__( 'Main Menu Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '13px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> 'body:not(.thsn-max-mega-menu-override) .thsn-navbar div > ul > li > a, .thsn-max-mega-menu-override #page #site-navigation .max-mega-menu > li.mega-menu-item > a.mega-menu-link',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'main-menu-active-color',
				'label'			=> esc_attr__( 'Main Menu Active Link Color', 'grevo' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu when the menu link is active', 'grevo' ),
				'default'		=> 'globalcolor',
				'choices'		=> $pre_text_color_list,
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'main-menu-sticky-color',
				'label'			=> esc_attr__( 'Main Menu Text Color for Sticky Header', 'grevo' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu text when header is sticky', 'grevo' ),
				'default'		=> '#101010',
			),
			array(
				'type'			=> 'color',
				'settings'		=> 'main-menu-sticky-active-color',
				'label'			=> esc_attr__( 'Main Menu Active Link Color for Sticky Header', 'grevo' ),
				'description'	=> esc_attr__( 'This color will be applied to main menu when the menu link is active in sticky header', 'grevo' ),
				'default'		=> '#101010',
			),
			// Dropdown Menu Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'drop-down-menu-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Dropdown Menu Options', 'grevo' ) . '</h2> <span>' . esc_html__( 'Set Dropdown font settings', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'dropdown-menu-typography',
				'label'			=> esc_attr__( 'Dropdown Menu Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '13px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> '.thsn-navbar ul ul a,
				.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-flyout > ul.mega-sub-menu li.mega-menu-item a.mega-menu-link,
				.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li > ul.mega-sub-menu li.mega-menu-item > a:hover, 
				.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li > ul.mega-sub-menu li.mega-menu-item > a:focus,
				.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu ul:not(.menu) > li.mega-menu-item > a.mega-menu-link,
				.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu li .widget_nav_menu ul.menu > li.mega-menu-item > a.mega-menu-link',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'drop-down-menu-active-color',
				'label'				=> esc_html__( 'Dropdown Menu Active Color', 'grevo' ),
				'default'			=> 'globalcolor',
				'choices'			=> $pre_text_color_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'dropdown_background',
				'label'			=> esc_attr__( 'Dropdown Menu Background', 'grevo' ),
				'description'	=> esc_attr__( 'Background settings for Dropdown Menu', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#fff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'thsn-output'	=> '.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-flyout > ul.mega-sub-menu,.thsn-navbar ul ul,.thsn-navbar ul ul:before',
			),
			// Max Mega Menu Option
			array(
				'type'			=> 'custom',
				'settings'		=> 'max-mega-menu-override-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Max Mega Menu Plugin Option', 'grevo' ) . '</h2> <span>' . esc_html__( 'Option for Max Mega Menu plugin', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'max-mega-menu-override',
				'label'			=> esc_attr__( 'Override Max Mega Menu design?', 'grevo' ),
				'description'	=> esc_attr__( 'Select YES to override Max Mega Menu design. Make sure you are using "Max Mega Menu" plugin for mega menu', 'grevo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'mmm-title-typography',
				'label'			=> esc_attr__( 'Max Mega Menu - Widget Title Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '18px',
					'line-height'		=> '20px',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'active_callback'=> array(
					array(
						'setting'	=> 'max-mega-menu-override',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
				'priority'		=> 10,
				'thsn-output'	=> '.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title, .thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li.mega-menu-megamenu > ul.mega-sub-menu li.mega-menu-column > ul.mega-sub-menu > li.mega-menu-item h4.mega-block-title',
			),
			array( // 1st dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-1-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 1st Dropdown Menu Background Option', 'grevo' ),
				'description'	=> esc_attr__( 'Background settings for first Dropdown Menu in Max Mega Menu', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#fff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'=> array(
					array(
						'setting'	=> 'max-mega-menu-override',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
				'thsn-output'	=> '.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(1) > ul.mega-sub-menu',
			),
			array( // 2nd dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-2-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 2nd Dropdown Menu Background Option', 'grevo' ),
				'description'	=> esc_attr__( 'Background settings for second Dropdown Menu in Max Mega Menu', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#fff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'=> array(
					array(
						'setting'	=> 'max-mega-menu-override',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
				'thsn-output'	=> '.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(2) > ul.mega-sub-menu',
			),
			array( // 3rd dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-3-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 3rd Dropdown Menu Background Option', 'grevo' ),
				'description'	=> esc_attr__( 'Background settings for third Dropdown Menu in Max Mega Menu', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#fff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'=> array(
					array(
						'setting'	=> 'max-mega-menu-override',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
				'thsn-output'	=> '.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(3) > ul.mega-sub-menu',
			),
			array( // 4th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-4-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 4th Dropdown Menu Background Option', 'grevo' ),
				'description'	=> esc_attr__( 'Background settings for fourth Dropdown Menu in Max Mega Menu', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#fff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'=> array(
					array(
						'setting'	=> 'max-mega-menu-override',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
				'thsn-output'	=> '.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(4) > ul.mega-sub-menu',
			),
			array( // 5th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-5-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 5th Dropdown Menu Background Option', 'grevo' ),
				'description'	=> esc_attr__( 'Background settings for fifth Dropdown Menu in Max Mega Menu', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#fff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'=> array(
					array(
						'setting'	=> 'max-mega-menu-override',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
				'thsn-output'	=> '.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(5) > ul.mega-sub-menu',
			),
			array( // 6th dropdown mega menu
				'type'			=> 'background',
				'settings'		=> 'mmm-6-dropdown',
				'label'			=> esc_attr__( 'Max Mega Menu - 6th Dropdown Menu Background Option', 'grevo' ),
				'description'	=> esc_attr__( 'Background settings for sixth Dropdown Menu in Max Mega Menu', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#fff',
					'background-image'		=> '',
					'background-repeat'		=> 'repeat',
					'background-position'	=> 'center center',
					'background-size'		=> 'cover',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'=> array(
					array(
						'setting'	=> 'max-mega-menu-override',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
				'thsn-output'	=> '.thsn-max-mega-menu-override #page #site-navigation .mega-menu-wrap > ul > li:nth-child(6) > ul.mega-sub-menu',
			),
		)
	),
	// Titlebar Options
	'titlebar_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Titlebar Options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'switch',
				'settings'		=> 'titlebar-enable',
				'label'			=> esc_attr__( 'Show Titlebar?', 'grevo' ),
				'description'	=> esc_attr__( 'Show or hide Titlebar', 'grevo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'titlebar-height',
				'label'			=> esc_attr__( 'Titlebar Height', 'grevo' ),
				'default'		=> 200,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 1000,
					'step'			=> 1,
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'titlebar-style',
				'label'			=> esc_attr__( 'Titlebar Style', 'grevo' ),
				'description'	=> esc_attr__( 'Select style for Titlebar', 'grevo' ),
				'default'		=> 'left',
				'choices'		=>  array(
					'left'			=> esc_attr__( 'All Left Aligned', 'grevo' ),
					'center'		=> esc_attr__( 'All Center Aligned', 'grevo' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'titlebar-hide-breadcrumb',
				'label'			=> esc_attr__( 'Hide Breadcrumb?', 'grevo' ),
				'description'	=> esc_attr__( 'Show or hide breadcrumb in Titlebar', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'multicheck',
				'settings'		=> 'titlebar-bg-featured',
				'label'			=> esc_attr__( 'Featured Image as Titlebar Background', 'grevo' ),
				'description'	=> esc_attr__( 'Select which section (CPT) will show featured image as background image in Titlebar. NOTE: This will work for Single view only.', 'grevo' ),
				'default'		=> array(),
				'choices'		=> array(
					'post'				=> sprintf( esc_attr__('For %1$s', 'grevo') , '"Post"' ),
					'page'				=> sprintf( esc_attr__('For %1$s', 'grevo') , '"Page"' ),
					'thsn-portfolio'	=> sprintf( esc_attr__('For %1$s', 'grevo') , '"'.$portfolio_cpt_singular_title.'"' ),
					'thsn-team-member'	=> sprintf( esc_attr__('For %1$s', 'grevo') , '"'.$team_cpt_singular_title.'"' ),
				),
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'titlebar-bgcolor',
				'label'				=> esc_html__( 'Select Titlebar background color', 'grevo' ),
				'default'			=> 'secondarycolor',
				'choices'			=> $pre_color_with_gradient_list,
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'titlebar-background',
				'label'			=> esc_attr__( 'Background', 'grevo' ),
				'description'	=> esc_attr__( 'Background Settings', 'grevo' ),
				'default'		=> array(
					'background-color'      => '#727272',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center center',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
				'thsn-output'	=> '.thsn-title-bar-wrapper, .thsn-title-bar-wrapper.thsn-bg-color-custom:before',
				'active_callback' => array( array(
					'setting'		=> 'titlebar-enable',
					'operator'		=> '==',
					'value'			=> '1',
				) ),
			),
			array(
				'type'		=> 'typography',
				'settings'	=> 'titlebar-heading-typography',
				'label'		=> esc_attr__( 'Titlebar Heading Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Quicksand',
					'variant'			=> '700',
					'font-size'			=> '50px',
					'line-height'		=> '60px',
					'letter-spacing'	=> '0px',
					'color'				=> '#fff',
					'text-transform'	=> 'None',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> '.thsn-tbar-title',
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'titlebar-subheading-typography',
				'label'			=> esc_attr__( 'Titlebar Sub-heading Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito Sans',
					'variant'			=> 'regular',
					'font-size'			=> '16px',
					'line-height'		=> '1.5',
					'letter-spacing'	=> '0px',
					'color'				=> '#fff',
					'text-transform'	=> 'none',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
				'priority'		=> 10,
				'thsn-output'	=> '.thsn-tbar-subtitle',
				'active_callback'	=> array( array(
					'setting'			=> 'titlebar-enable',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'typography',
				'settings'		=> 'titlebar-breadcrumb-typography',
				'label'			=> esc_attr__( 'Titlebar Breadcrumb Typography', 'grevo' ),
				'choices'		=> [ 'fonts' => [ 'google' => [ 'popularity', 600 ], ], ],
				'default'		=> array(
					'font-family'		=> 'Nunito Sans',
					'variant'			=> '400',
					'font-size'			=> '15px',
					'line-height'		=> '1.5',
					'letter-spacing'	=> '0px',
					'color'				=> '#101010',
					'text-transform'	=> 'uppercase',
					'font-backup'		=> '',
					'font-style'		=> 'normal',
				),
			'priority'				=> 10,
				'thsn-output'		=> '.thsn-breadcrumb, .thsn-breadcrumb a',
				'active_callback'	=> array(
					array(
						'setting'			=> 'titlebar-enable',
						'operator'			=> '==',
						'value'				=> '1',
					),
					array(
						'setting'			=> 'titlebar-hide-breadcrumb',
						'operator'			=> '==',
						'value'				=> '0',
					)
				),
			),
		),
	),
	// Footer Options
	'footer_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Footer Options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
		// Footer Background settings
		array(
			'type'			=> 'custom',
			'settings'		=> 'footer-background-settings-heading',
			'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Footer Background Settings', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Manage footer background settings from here', 'grevo' ) . '</span></div>',
		),
		array(
			'type'			=> 'radio-image',
			'settings'		=> 'footer-style',
			'label'			=> esc_html__( 'Select Footer Style', 'grevo' ),
			'default'		=> '1',
			'choices'		=> array(
				'1'				=> get_template_directory_uri() . '/includes/images/footer-style-1.jpg',
				'2'				=> get_template_directory_uri() . '/includes/images/footer-style-2.jpg',
			)
		),

	
		// Footer Boxes Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-boxes-area-heading',
				'default'		=> '<div class="grevo-option-heading"><h2>' . esc_html__( 'Footer Boxes Area', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Manage footer boxes from here', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-boxes-area',
				'label'			=> esc_attr__( 'Show footer boxes?', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
		

		// 1st box
		array(
			'type'			=> 'themesion_icon_picker',
			'settings'		=> 'footer-box-1-icon',
			'label'			=> esc_attr__( '1st Footer box - Icon', 'grevo' ),
			'description'	=> esc_attr__( 'Select icon for 1st box', 'grevo' ),
			'default'		=> esc_attr('thsn-grevo-icon thsn-grevo-icon-email;fa fa-map-marker;sgicon sgicon-Pointer'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
		),
		array(
			'type'		=> 'text',
			'settings'	=> 'footer-box-1-title',
			'label'		=> esc_attr__( '1st Footer Box - Title', 'grevo' ),
			'default'	=> esc_attr('Call us for any question'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
			'partial_refresh'	=> array(
				'footer-box-1-title'		=> array(
					'selector'			=> '.thsn-label-1',
					'render_callback'	=> function() {
						return do_shortcode(get_theme_mod('footer-box-1-title'));
					},
				)
			),
		),
		array(
			'type'		=> 'text',
			'settings'	=> 'footer-box-1-content',
			'label'		=> esc_attr__( '1st Footer Box - Content', 'grevo' ),
			'default'	=> esc_attr('(+00)888.666.88'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
		),

		// 2nd box
		array(
			'type'			=> 'themesion_icon_picker',
			'settings'		=> 'footer-box-2-icon',
			'label'			=> esc_attr__( '2st Footer box - Icon', 'grevo' ),
			'description'	=> esc_attr__( 'Select icon for 2st box', 'grevo' ),
			'default'		=> esc_attr('thsn-grevo-icon thsn-grevo-icon-email;fa fa-map-marker;sgicon sgicon-Pointer'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
		),
		array(
			'type'		=> 'text',
			'settings'	=> 'footer-box-2-title',
			'label'		=> esc_attr__( '2st Footer Box - Title', 'grevo' ),
			'default'	=> esc_attr('Call us for any question'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
			'partial_refresh'	=> array(
				'footer-box-2-title'		=> array(
					'selector'			=> '.thsn-label-2',
					'render_callback'	=> function() {
						return do_shortcode(get_theme_mod('footer-box-2-title'));
					},
				)
			),
		),
		array(
			'type'		=> 'text',
			'settings'	=> 'footer-box-2-content',
			'label'		=> esc_attr__( '2st Footer Box - Content', 'grevo' ),
			'default'	=> esc_attr('(+00)888.666.88'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
		),

	// 3rd box
		array(
			'type'			=> 'themesion_icon_picker',
			'settings'		=> 'footer-box-3-icon',
			'label'			=> esc_attr__( '3rd Footer box - Icon', 'grevo' ),
			'description'	=> esc_attr__( 'Select icon for 3rd box', 'grevo' ),
			'default'		=> esc_attr('thsn-grevo-icon thsn-grevo-icon-email;fa fa-map-marker;sgicon sgicon-Pointer'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
		),
		array(
			'type'		=> 'text',
			'settings'	=> 'footer-box-3-title',
			'label'		=> esc_attr__( '3rd Footer Box - Title', 'grevo' ),
			'default'	=> esc_attr('Call us for any question'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
			'partial_refresh'	=> array(
				'footer-box-3-title'		=> array(
					'selector'			=> '.thsn-label-3',
					'render_callback'	=> function() {
						return do_shortcode(get_theme_mod('footer-box-3-title'));
					},
				)
			),
		),
		array(
			'type'		=> 'text',
			'settings'	=> 'footer-box-3-content',
			'label'		=> esc_attr__( '3rd Footer Box - Content', 'grevo' ),
			'default'	=> esc_attr('(+00)888.666.88'),
			'active_callback'	=> array( array(
				'setting'			=> 'footer-boxes-area',
				'operator'			=> '==',
				'value'				=> '1',
			) ),
		),
			

			array(
				'type'			=> 'radio-image',
				'settings'		=> 'footer-bgcolor',
				'label'			=> esc_html__( 'Select Footer background color', 'grevo' ),
				'default'		=> 'blackish',
				'choices'		=> $pre_color_with_gradient_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-background',
				'label'			=> esc_attr__( 'Background', 'grevo' ),
				'description'	=> esc_attr__( 'Background Settings', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#0c0732',
					'background-image'		=> '',
					'background-repeat'		=> 'no-repeat',
					'background-position'	=> 'center top',
					'background-size'		=> 'contain',
					'background-attachment'	=> 'scroll',
				),
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-bgcolor',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
				'thsn-output'	=> '.site-footer, .site-footer.thsn-bg-color-custom:before',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-text-color',
				'label'				=> esc_attr__( 'Select Footer Text Color', 'grevo' ),
				'default'			=> 'white',
				'choices'			=> $pre_text_color_list,
			),

			// Footer Widget Area
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-widget-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Footer Widget Area', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Manage widget area settings', 'grevo' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'footer-column',
				'label'		=> esc_html__( 'Footer Widget Column Type', 'grevo' ),
				'description'	=> esc_html__( 'This will show widgets. You can manage it from "Admin > Appearance > Widgets" section.', 'grevo' ),
				'default'	=> '3-3-3-3',
				'choices'		=> array(
					'12'		=> get_template_directory_uri() . '/includes/images/footer-12.png',
					'6-6'		=> get_template_directory_uri() . '/includes/images/footer-6-6.png',
					'4-4-4'		=> get_template_directory_uri() . '/includes/images/footer-4-4-4.png',
					'3-3-3-3'	=> get_template_directory_uri() . '/includes/images/footer-3-3-3-3.png',
					'2-2-2-6'	=> get_template_directory_uri() . '/includes/images/footer-2-2-2-6.png',
					'6-2-2-2'	=> get_template_directory_uri() . '/includes/images/footer-6-2-2-2.png',
					'8-4'		=> get_template_directory_uri() . '/includes/images/footer-8-4.png',
					'4-8'		=> get_template_directory_uri() . '/includes/images/footer-4-8.png',
					'custom'	=> get_template_directory_uri() . '/includes/images/footer-col-custom.png',
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-1-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 1st Column', 'grevo' ),
				'description'	=> esc_attr__( 'Set custom width of the 1st column in footer widget area', 'grevo' ),
				'default'		=> '25',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-2-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 2nd Column', 'grevo' ),
				'description'	=> esc_attr__( 'Set custom width of the 2nd column in footer widget area', 'grevo' ),
				'default'		=> '50',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-3-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 3rd Column', 'grevo' ),
				'description'	=> esc_attr__( 'Set custom width of the 3rd column in footer widget area', 'grevo' ),
				'default'		=> '25',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'			=> 'select',
				'settings'		=> 'footer-4-col-width',
				'label'			=> esc_attr__( 'Footer Widget Width - 4th Column', 'grevo' ),
				'description'	=> esc_attr__( 'Set custom width of the 4th column in footer widget area', 'grevo' ),
				'default'		=> '30',
				'choices'		=> $footer_col_width_array,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-column',
						'operator'			=> '==',
						'value'				=> 'custom',
					)
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-widget-bgcolor',
				'label'				=> esc_html__( 'Select Footer Widget Area background color', 'grevo' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_color_with_gradient_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-widget-background',
				'label'			=> esc_attr__( 'Footer Widget Area Background', 'grevo' ),
				'description'	=> esc_attr__( 'Background Settings for footer widget area', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#969696',
				    'background-image'		=> '',
				    'background-repeat'		=> 'repeat',
				    'background-position'	=> 'center center',
				    'background-size'		=> 'cover',
				    'background-attachment'	=> 'scroll',
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'footer-widget-bgcolor',
							'operator'	=> '==',
							'value'		=> 'custom',
						),
					)
				),
				'thsn-output'	=> '.thsn-footer-widget-area, .thsn-footer-widget-area.thsn-bg-color-custom:before',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-widget-color-switch',
				'label'			=> esc_attr__( 'Set Custom Text Color for Widget Area?', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-widget-text-color',
				'label'				=> esc_attr__( 'Footer Widget Area Text Color', 'grevo' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_text_color_list,
				'active_callback'	=> array(
					array(
						'setting'			=> 'footer-widget-color-switch',
						'operator'			=> '==',
						'value'				=> '1',
					)
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'footer-copyright-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Footer Copyright Text Area', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Manage bottom footer area from here', 'grevo' ) . '</span></div>',
			),

			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-copyright-bgcolor',
				'label'				=> esc_html__( 'Select Footer Copyright Area background color', 'grevo' ),
				'default'			=> 'transparent',
				'choices'			=> $pre_color_with_gradient_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'footer-copyright-background',
				'label'			=> esc_attr__( 'Footer Copyright Area Background', 'grevo' ),
				'description'	=> esc_attr__( 'Background Settings for footer copyright area', 'grevo' ),
				'default'		=> array(
					'background-color'		=> '#0a0a0a',
				    'background-image'		=> '',
				    'background-repeat'		=> 'repeat',
				    'background-position'	=> 'center center',
				    'background-size'		=> 'cover',
				    'background-attachment'	=> 'scroll',
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'footer-copyright-bgcolor',
							'operator'	=> '==',
							'value'		=> 'custom',
						),
					)
				),
				'thsn-output'	=> '.thsn-footer-text-area, .thsn-footer-text-area.thsn-bg-color-custom:before',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-copyright-color-switch',
				'label'			=> esc_attr__( 'Set Custom Text Color for Copyright Area?', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'footer-copyright-text-color',
				'label'				=> esc_attr__( 'Footer Copyright Area Text Color', 'grevo' ),
				'default'			=> 'white',
				'choices'			=> array_merge( array('inherit' => get_template_directory_uri() . '/includes/images/precolor-inherit.png'), $pre_text_color_list ),
				'active_callback'	=> array(
					array(
						'setting'		=> 'footer-copyright-color-switch',
						'operator'		=> '==',
						'value'			=> '1',
					)
				),
			),

			array(
				'type'			=> 'editor',
				'settings'		=> 'copyright-text',
				'label'			=> esc_attr__( 'Footer Copyright Text', 'grevo' ),
				'default'		=> sprintf( esc_attr__( 'Copyright &copy; %1$s All Rights Reserved.', 'grevo' ), date('Y') ) ,
				'priority'		=> 10,
				'partial_refresh'	=> array(
					'copyright-text'		=> array(
						'selector'			=> '.thsn-footer-copyright-text-area',
						'render_callback'	=> function() {
							return do_shortcode(get_theme_mod('copyright-text'));
						},
					)
				),
			),
			
			array(
				'type'				=> 'image',
				'settings'			=> 'footer-logo',
				'label'				=> esc_attr__( 'Footer Logo', 'grevo' ),
				'description'		=> esc_attr__( 'Footer Main logo', 'grevo' ),
			),         

			array(
				'type'			=> 'select',
				'settings'		=> 'footer-copyright-right-content',
				'label'			=> esc_attr__( 'Footer Right Area', 'grevo' ),
				'description'	=> esc_attr__( 'What you like to show at right side or copyright text', 'grevo' ),
				'default'		=> 'menu',
				'choices'		=> array(
					'social'		=> esc_attr__( 'Show Social Links', 'grevo' ),
					'menu'			=> esc_attr__( 'Show Footer Menu', 'grevo' ),
					'none'			=> esc_attr__( 'None', 'grevo' ),
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'footer-style',
							'operator'	=> '==',
							'value'		=> '1',
						),	
					)
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'footer-social-link',
				'label'			=> esc_attr__( 'Show/Hide Social Link', 'grevo' ),
				'description'	=> esc_attr__( 'What you like to show at right side or copyright text', 'grevo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
				'active_callback'=> array(
					array(
						array(
							'setting'	=> 'footer-style',
							'operator'	=> '==',
							'value'		=> '2',
						),	
					)
				),
			),

		)
	),

	// Social Links Options
	'social_links_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Social Links Options', 'grevo' ),
			'description'	=> esc_attr__( 'You can use [thsn-social-links] shortcode for social list with icon.', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => $social_options_array
	),

	// Blog Settings
	'blog_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Blog Options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Blog Settings', 'grevo' ) . '</h2> <span>' . esc_html__( 'Settings for Blogroll, Category, Tag, Archives etc section.', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blogroll-view',
				'label'			=> esc_html__( 'Blogroll view', 'grevo' ),
				'default'		=> 'classic',
				'choices'		=> thsn_element_template_list('blog', 'customizer'),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blogroll-column',
				'label'			=> esc_html__( 'Blogroll column', 'grevo' ),
				'default'		=> '3',
				'choices'		=> $column_list,
				'active_callback'	=> array(
					array(
						'setting'		=> 'blogroll-view',
						'operator'		=> '!=',
						'value'			=> 'classic',
					)
				),
			),
			array(
			'type'			=> 'switch',
			'settings'		=> 'blog-show-related',
			'label'			=> esc_attr__( 'Show Related Post?', 'grevo' ),
			'default'		=> '0',
			'choices'     => array(
				'on'  => esc_attr__( 'Yes', 'grevo' ),
				'off' => esc_attr__( 'No', 'grevo' ),
			),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'blog-related-title',
				'label'			=> esc_attr__( 'Related Post Section Title', 'grevo' ), 
				'description'	=> esc_attr__( 'Related Area Title', 'grevo' ),
				'default'		=> esc_attr__( 'Related Post', 'grevo' ),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-related-count',
				'label'			=> esc_attr__( 'How many post you like to show', 'grevo' ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blog-related-column',
				'label'			=>  esc_html__('Related Post Column', 'grevo' ),
				'default'		=> '3',
				'choices'     => $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'blog-related-style',
				'label'			=> esc_html__( 'Related Post View', 'grevo' ),
				'default'		=> '1',
				'choices'     => $blog_styles,
				'active_callback' => array(
					array(
						'setting'	=> 'blog-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-classic-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Blog Classic Settings', 'grevo' ) . '</h2> <span>' . esc_html__( 'Settings for Blog Classic view.', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'blog-classic-limit-switch',
				'label'			=> esc_attr__( 'Limit Content Words for Blog Classic view?', 'grevo' ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-classic-limit',
				'label'			=> esc_attr__( 'Set Word Limit for Blog Classic view', 'grevo' ),
				'description'	=> esc_attr__( 'This will add limited words before "Read More" link. This is useful if you didn\'t added Read More link in posts.', 'grevo' ),
				'default'		=> 15,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-classic-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-element-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Blog Style Elements (boxes) Settings', 'grevo' ) . '</h2> <span>' . esc_html__( 'Settings for Blog Style Elements.', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'blog-element-limit-switch',
				'label'			=> esc_attr__( 'Limit Content Words for Blog Element view?', 'grevo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'blog-element-limit',
				'label'			=> esc_attr__( 'Limit Words for Blog Element view', 'grevo' ),
				'description'	=> esc_attr__( 'This will add limited words before "Read More" link.', 'grevo' ),
				'default'		=> 30,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 900,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'blog-element-limit-switch',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-blog-sidebar-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'grevo' ) . '</h2> <span>' . esc_html__( 'Select sidebar position Page and Blog section.', 'grevo' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-post',
				'label'		=> esc_html__( 'Blog Sidebar', 'grevo' ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
		)
	),
	// Portfolio Settings
	'portfolio_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'grevo' ) , $portfolio_cpt_singular_title ) ,
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-settings',
				'default'		=> '<div class="themesion-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'grevo' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Options for Single %1$s Section', 'grevo' ), $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'portfolio-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'grevo' ), $portfolio_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $portfolio_single_style_array,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-detailsbox-settings',
				'default'		=> '<div class="themesion-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Details Box Options', 'grevo' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . esc_attr__( 'Details Box Settings', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-details-title',
				'label'			=> sprintf( esc_attr__( 'Single %1$s Details Box Title', 'grevo' ), $portfolio_cpt_singular_title ),
				'description'	=> esc_attr__( 'Details Box Title', 'grevo' ),
				'default'		=> esc_attr__( 'Project info', 'grevo' ),
			),
			array(
				'type'			=> 'repeater',
				'label'			=> sprintf( esc_attr__( 'Single %1$s Details Box', 'grevo' ), $portfolio_cpt_singular_title ),
				'row_label'		=> array(
					'type'			=> 'field',
					'value'			=> esc_attr__('Line', 'grevo' ),
					'field'			=> 'line_title',
				),
				'button_label'	=> esc_attr__('Add New Line', 'grevo' ),
				'settings'		=> 'portfolio-details',
				'fields'		=> array(
					'line_title'	=> array(
						'type'			=> 'text',
						'label'			=> esc_attr__( 'Line Title', 'grevo' ),
						'description'	=> esc_attr__( 'This will be the label for the line', 'grevo' ),
						'default'		=> '',
					),
					'line_type'		=> array(
						'type'			=> 'select',
						'label'			=> esc_attr__( 'Line Type', 'grevo' ),
						'description'	=> esc_attr__( 'This will be type for the line', 'grevo' ),
						'default'		=> 'text',
						'choices'		=> array(
							'text'			=> esc_attr__( 'Normal Text', 'grevo' ),
							'category'		=> esc_attr__( 'Category List (without link)', 'grevo' ),
							'category-link'	=> esc_attr__( 'Category List (with link)', 'grevo' ),
						)
					),
				),
				'default'		=> array(
					array(
						'line_title'	=> esc_attr__('Date', 'grevo'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Client', 'grevo'),
						'line_type'		=> 'text',
					),
					array(
						'line_title'	=> esc_attr__('Category', 'grevo'),
						'line_type'		=> 'category-link',
					),
					array(
						'line_title'	=> esc_attr__('Address', 'grevo'),
						'line_type'		=> 'text',
					),
    			),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-portfolio-related-settings',
				'default'		=> '<div class="themesion-option-heading"><h2>' . sprintf( esc_html__( 'Related %1$s Options', 'grevo' ), $portfolio_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_html__( 'Options for Related %1$s', 'grevo' ), $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'portfolio-show-related',
				'label'			=> sprintf( esc_attr__( 'Show Related %1$s?', 'grevo' ), $portfolio_cpt_singular_title ),
				'default'		=> '0',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-related-title',
				'label'			=> sprintf( esc_attr__( 'Related %1$s Section Title', 'grevo' ), $portfolio_cpt_singular_title ),
				'description'	=> esc_attr__( 'Related Area Title', 'grevo' ),
				'default'		=> sprintf( esc_attr__( 'Related %1$s', 'grevo' ), $portfolio_cpt_singular_title ),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'portfolio-related-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show', 'grevo' ), $portfolio_cpt_singular_title ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-related-column',
				'label'			=> sprintf( esc_html__( 'Related %1$s Column', 'grevo' ), $portfolio_cpt_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-related-style',
				'label'			=> sprintf( esc_html__( 'Related %1$s View', 'grevo' ), $portfolio_cpt_singular_title ),
				'default'		=> '2',
				'choices'		=> thsn_element_template_list('portfolio', true),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-portfolio-cat-view',
				'default'		=> '<div class="themesion-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'grevo' ), $portfolio_cat_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'grevo' ) , $portfolio_cat_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-cat-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'grevo' ), $portfolio_cat_singular_title ),
				'default'		=> '1',
				'choices'		=> thsn_element_template_list('portfolio', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'portfolio-cat-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'grevo' ), $portfolio_cat_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'portfolio-cat-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'grevo' ), $portfolio_cpt_singular_title, $portfolio_cat_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-portfolio-sidebar-settings',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'grevo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'grevo' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-portfolio',
				'label'		=> sprintf( esc_html__( '%1$s (Single view) Sidebar', 'grevo' ), $portfolio_cpt_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-portfolio-category',
				'label'		=> sprintf( esc_html__( '%1$s (also CPT archive) Sidebar', 'grevo' ), $portfolio_cat_singular_title ),
				'default'	=> 'right',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'portfolio-advanced-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Advanced Options', 'grevo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'grevo' ) , $portfolio_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'grevo' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'grevo' ),
				'default'		=> esc_attr__( 'Portfolio', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'grevo' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'grevo' ),
				'default'		=> esc_attr__( 'Portfolio', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'grevo' ) , $portfolio_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'grevo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'grevo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'grevo' ), thsn_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'portfolio' ),
				'priority'		=> 10,
			),
			// Portfolio Category
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'grevo' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'grevo' ),
				'default'		=> esc_attr__( 'Portfolio Categories', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'grevo' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'grevo' ),
				'default'		=> esc_attr__( 'Portfolio Category', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'portfolio-cat-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'grevo' ) , $portfolio_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug', 'grevo' ),
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'grevo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'grevo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'grevo' ), thsn_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'priority'		=> 10,
			),
		)
	),
	// Service Settings
	'service_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'grevo' ) , $service_cpt_singular_title ) ,
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-service-settings',
				'default'		=> '<div class="themesion-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'grevo' ), $service_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'grevo' ), $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'service-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'grevo' ), $service_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $service_single_style_array,
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'service-single-image-hide',
				'label'			=> sprintf( esc_attr__( 'Hide Featured Image on Single %1$s page? ', 'grevo' ), $service_cpt_singular_title ),
				'default'		=> '0',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
				'active_callback' => array(
					array(
						'setting'	=> 'service-single-style',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'service-show-related',
				'label'			=> sprintf( esc_attr__( 'Show Related %1$s', 'grevo' ), $service_cpt_singular_title ),
				'default'		=> '0',
				'choices'     => array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
			'type'			=> 'text',
			'settings'		=> 'service-related-title',
			'label'			=> sprintf( esc_attr__( 'Related %1$s Section Title', 'grevo' ), $service_cpt_singular_title ),
			'description'	=> esc_attr__( 'Related Area Title', 'grevo' ),
			'default'		=> sprintf( esc_attr__( 'Related %1$s', 'grevo' ), $service_cpt_singular_title ),
			'active_callback' => array(
				array(
					'setting'	=> 'service-show-related',
					'operator'	=> '==',
					'value'		=> '1',
				),
			),
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'service-related-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show', 'grevo' ), $service_cpt_singular_title ),
				'default'		=> 3,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-related-column',
				'label'			=> sprintf( esc_html__( 'Related %1$s Column', 'grevo' ), $service_cpt_singular_title ),
				'default'		=> '3',
				'choices'     => $column_list,
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-related-style',
				'label'			=> sprintf( esc_html__( 'Related %1$s View', 'grevo' ), $service_cpt_singular_title ),
				'default'		=> '2',
				'choices'     => thsn_element_template_list('service', true),
				'active_callback' => array(
					array(
						'setting'	=> 'service-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-service-cat-view',
				'default'		=> '<div class="themesion-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'grevo' ), $service_cat_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'grevo' ) , $service_cat_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-cat-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'grevo' ), $service_cat_singular_title ),
				'default'		=> '1',
				'choices'		=> thsn_element_template_list('service', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'service-cat-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'grevo' ), $service_cat_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'service-cat-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'grevo' ), $service_cpt_singular_title, $service_cat_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-service-sidebar-settings',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'grevo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'grevo' ) , $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-service',
				'label'		=> sprintf( esc_html__( '%1$s (Single View) Sidebar', 'grevo' ), $service_cpt_singular_title ),
				'default'	=> 'left',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-service-category',
				'label'		=> sprintf( esc_html__( '%1$s (also CPT archive) Sidebar', 'grevo' ), $service_cat_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Advanced - Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'service-advanced-heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Advanced Options', 'grevo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'grevo' ) , $service_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'grevo' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'grevo' ),
				'default'		=> esc_attr__( 'Service', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'grevo' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'grevo' ),
				'default'		=> esc_attr__( 'Service', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'grevo' ) , $service_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'grevo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'grevo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'grevo' ), thsn_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'service' ),
				'priority'		=> 10,
			),
			// Service Category
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'grevo' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'grevo' ),
				'default'		=> esc_attr__( 'Service Categories', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'grevo' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'grevo' ),
				'default'		=> esc_attr__( 'Service Category', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'service-cat-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'grevo' ) , $service_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'grevo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'grevo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'grevo' ), thsn_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'service-category' ),
				'priority'		=> 10,
			),
		)
	),
	// Team Member Settings
	'team_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'grevo' ) , $team_cpt_singular_title ) ,
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-single-team-settings',
				'default'		=> '<div class="themesion-option-heading"><h2>' . sprintf( esc_html__( 'Single %1$s Options', 'grevo' ), $team_cpt_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'grevo' ), $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'team-single-style',
				'label'		=> sprintf( esc_html__( '%1$s Single View Style', 'grevo' ), $team_cpt_singular_title ),
				'default'	=> '1',
				'choices'		=> $team_single_style_array,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-team-group-view',
				'default'		=> '<div class="themesion-option-heading"><h2>' . sprintf( esc_html__( 'Element View Style for %1$s', 'grevo' ), $team_group_singular_title ) . '</h2> <span>' . sprintf( esc_attr__( 'Select view style for elements on %1$s', 'grevo' ) , $team_group_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'team-group-style',
				'label'			=> sprintf( esc_html__( 'Element View on %1$s', 'grevo' ), $team_group_singular_title ),
				'default'		=> '1',
				'choices'		=> thsn_element_template_list('team', true),
			),
			array(
				'type'			=> 'radio-image',
				'settings'		=> 'team-group-column',
				'label'			=> sprintf( esc_html__( '%1$s View Column', 'grevo' ), $team_group_singular_title ),
				'default'		=> '3',
				'choices'		=> $column_list,
			),
			array(
				'type'			=> 'number',
				'settings'		=> 'team-group-count',
				'label'			=> sprintf( esc_attr__( 'How many %1$s you like to show on single %2$s page', 'grevo' ), $team_cpt_singular_title, $team_group_singular_title ),
				'default'		=> 9,
				'choices'		=> array(
					'min'			=> 1,
					'max'			=> 50,
					'step'			=> 1,
				),
				'active_callback' => array(
					array(
						'setting'	=> 'portfolio-show-related',
						'operator'	=> '==',
						'value'		=> '1',
					),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'custom-team-member-sidebar-settings',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Sidebar Options', 'grevo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Sidebar options for %1$s Section', 'grevo' ) , $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-team-member',
				'label'		=> sprintf( esc_html__( '%1$s (Sinlge View) Sidebar', 'grevo' ), $team_cpt_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-team-group',
				'label'		=> sprintf( esc_html__( '%1$s (also CPT archive) Sidebar', 'grevo' ), $team_group_singular_title ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'team_advanced_heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Advanced Options', 'grevo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'grevo' ) , $team_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'grevo' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'grevo' ),
				'default'		=> esc_attr__( 'Team Members', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'grevo' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'grevo' ),
				'default'		=> esc_attr__( 'Team Member', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-cpt-slug',
				'label'			=> sprintf( esc_attr__( '%1$s Section URl Slug', 'grevo' ) , $team_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT URL slug.', 'grevo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'grevo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'grevo' ), thsn_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'team' ),
				'priority'		=> 10,
			),
			// Team Member group
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'grevo' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'grevo' ),
				'default'		=> esc_attr__( 'Team Groups', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'grevo' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'grevo' ),
				'default'		=> esc_attr__( 'Team Group', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'team-group-slug',
				'label'			=> sprintf( esc_attr__( '%1$s URl Slug', 'grevo' ) , $team_group_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy URL slug.', 'grevo' ) . '<br />' . '<strong>' . esc_attr__( 'NOTE:', 'grevo' ) . '</strong> ' . sprintf( esc_attr__( 'After changing this, please go to %1$s section and save it once.', 'grevo' ), thsn_esc_kses('<a href="' . esc_url( get_admin_url().'options-permalink.php' ) . '" target="_blank"><strong>Settings > Permalinks</strong></a>') ) . '<br /><br />',
				'default'		=> esc_attr( 'team-group' ),
				'priority'		=> 10,
			),
		)
	),
	// Testimonial Settings
	'testimonial_options' => array(
		'section_settings' => array(
			'title'			=> sprintf( esc_attr__( '%1$s options', 'grevo' ) , $testimonial_cpt_singular_title ) ,
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'testimonial_advanced_heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Advanced Options', 'grevo' ) . '</h2> <span>' . sprintf( esc_attr__( 'Advanced Options for %1$s Section', 'grevo' ) , $testimonial_cpt_singular_title ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cpt-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title', 'grevo' ) , $testimonial_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Title', 'grevo' ),
				'default'		=> esc_attr__( 'Testimonials', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cpt-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Section Title (Singular)', 'grevo' ) , $testimonial_cpt_singular_title ) ,
				'description'	=> esc_attr__( 'CPT Singular Title', 'grevo' ),
				'default'		=> esc_attr__( 'Testimonial', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cat-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title', 'grevo' ) , $testimonial_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Title', 'grevo' ),
				'default'		=> esc_attr__( 'Testimonial Categories', 'grevo' ),
				'priority'		=> 10,
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'testimonial-cat-singular-title',
				'label'			=> sprintf( esc_attr__( '%1$s Title (Singular)', 'grevo' ) , $testimonial_cat_singular_title ) ,
				'description'	=> esc_attr__( 'Taxonomy Singular Title', 'grevo' ),
				'default'		=> esc_attr__( 'Testimonial Category', 'grevo' ),
				'priority'		=> 10,
			),
		)
	),
	// Search Settings
	'search_results_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Search Results options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'search_results_heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Search Results Settings', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Settings for Search Results page', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'no-results-title',
				'label'			=> esc_attr__( 'Title for "No Search Results" page', 'grevo' ),
				'description'	=> esc_attr__( 'Title to show when there is no search results', 'grevo' ),
				'default'		=> esc_attr__( 'No Results Found', 'grevo' ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'no-results-text',
				'label'			=> esc_attr__( 'Text for "No Search Results" page', 'grevo' ),
				'description'	=> esc_attr__( 'Text to show when there is no search results', 'grevo' ),
				'default'		=> esc_attr__('Sorry, but nothing matched your search terms. Please try again with some different keywords.','grevo'),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'search-sidebar-options',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Sidebar Settings', 'grevo' ) . '</h2> <span>' . esc_html__( 'Select sidebar position for search results page.', 'grevo' ) . '</span></div>',
			),
			array(
				'type'		=> 'radio-image',
				'settings'	=> 'sidebar-search',
				'label'		=> esc_html__( 'Search Results Sidebar', 'grevo' ),
				'default'	=> 'no',
				'choices'		=> array(
					'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
					'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
					'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
				),
			),
		)
	),

	// Login Page Settings
	'login_page_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Login Page options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'login_page_heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Login Page Settings', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Settings for Login Page page', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'custom-login-logo',
				'label'			=> esc_attr__( 'Show different logo?', 'grevo' ),
				'description'	=> esc_attr__( 'Show different logo then the default logo you selected for your site.', 'grevo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'login-logo',
				'label'				=> esc_attr__( 'Login Page Custom Logo', 'grevo' ),
				'description'		=> esc_attr__( 'Select logo for the login page', 'grevo' ),
				'default'			=> get_template_directory_uri() . '/images/logo.png',
				'active_callback'	=> array( array(
					'setting'			=> 'custom-login-logo',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'login-page-background',
				'label'			=> esc_attr__( 'Login Page Background', 'grevo' ),
				'description'	=> esc_attr__( 'Background Settings for the login page', 'grevo' ),
				'default'		=> array(				
					'background-color'      => '#444444',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center top',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
			),
		)
	),

	// Error 404 Settings
	'error_404_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Error 404 options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Error 404 Settings', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Settings for error 404 page', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'text',
				'settings'		=> 'error-404-heading',
				'label'			=> esc_attr__( 'Error 404 Heading', 'grevo' ),
				'description'	=> esc_attr__( 'This is heading for 404 page', 'grevo' ),
				'default'		=> esc_attr__( '404', 'grevo' ),
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'error-404-text',
				'label'			=> esc_attr__( 'Error 404 Text', 'grevo' ),
				'description'	=> esc_attr__( 'This is text for 404 page', 'grevo' ),
				'default'		=> esc_attr__( 'OOPS! THE PAGE YOU WERE LOOKING FOR, COULDN\'T BE FOUND.', 'grevo' ),
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'error-404-show-search',
				'label'			=> esc_attr__( 'Show search form on 404 page', 'grevo' ),
				'default'		=> '1',
				'priority'		=> 10,
				'choices'		=> array(
					'on'			=> esc_attr__( 'Yes', 'grevo' ),
					'off'			=> esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_text_custom',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Error 404 Text Color', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Settings for text color for 404 error page', 'grevo' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'e404-text-color',
				'label'				=> esc_attr__( 'Select 404 page text color', 'grevo' ),
				'default'			=> 'white',
				'choices'			=> $pre_text_color_2_list,
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'error_404_bg_custom',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Error 404 Background Option', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Settings for background color/image for 404 error page', 'grevo' ) . '</span></div>',
			),
			array(
				'type'				=> 'radio-image',
				'settings'			=> 'e404-bgcolor',
				'label'				=> esc_html__( 'Select 404 page background color', 'grevo' ),
				'default'			=> 'custom',
				'choices'			=> $pre_color_list,
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'e404-background',
				'label'			=> esc_attr__( 'Background', 'grevo' ),
				'description'	=> esc_attr__( 'Background Settings', 'grevo' ),
				'default'		=> array(				
					'background-color'      => '#8cc63f',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center top',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
				'thsn-output'	=> '.error404 .site-content-wrap, .error404 .thsn-bg-color-custom > .site-content-wrap:before',
			),
		)
	),
	// Login Page Settings
	'login_page_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'Login Page options', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			array(
				'type'			=> 'custom',
				'settings'		=> 'login_page_heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Login Page Settings', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Settings for Login Page page', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'switch',
				'settings'		=> 'custom-login-logo',
				'label'			=> esc_attr__( 'Show different logo?', 'grevo' ),
				'description'	=> esc_attr__( 'Show different logo then the default logo you selected for your site.', 'grevo' ),
				'default'		=> '1',
				'choices'		=> array(
					'on'  => esc_attr__( 'Yes', 'grevo' ),
					'off' => esc_attr__( 'No', 'grevo' ),
				),
			),
			array(
				'type'				=> 'image',
				'settings'			=> 'login-logo',
				'label'				=> esc_attr__( 'Login Page Custom Logo', 'grevo' ),
				'description'		=> esc_attr__( 'Select logo for the login page', 'grevo' ),
				'default'			=> get_template_directory_uri() . '/images/logo.png',
				'active_callback'	=> array( array(
					'setting'			=> 'custom-login-logo',
					'operator'			=> '==',
					'value'				=> '1',
				) ),
			),
			array(
				'type'			=> 'background',
				'settings'		=> 'login-page-background',
				'label'			=> esc_attr__( 'Login Page Background', 'grevo' ),
				'description'	=> esc_attr__( 'Background Settings for the login page', 'grevo' ),
				'default'		=> array(				
					'background-color'      => '#444444',
					'background-repeat'     => 'no-repeat',
					'background-position'   => 'center top',
					'background-size'       => 'cover',
					'background-attachment' => 'scroll',
				),
				'thsn-output'	=> '.error404 .site-content-wrap, .error404 .thsn-bg-color-custom > .site-content-wrap:before',
			),
		)
	),
	// Custom CSS/JS Options
	'custom_code_options' => array(
		'section_settings' => array(
			'title'			=> esc_attr__( 'CSS/JS Code', 'grevo' ),
			'panel'			=> 'grevo_base_options',
			'priority'		=> 160,
		),
		'section_fields' => array(
			// Heading Options
			array(
				'type'			=> 'custom',
				'settings'		=> 'tracking_js_heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Tracking Code', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Code for Google Tracking or other ', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'tracking-code',
				'label'			=> esc_attr__( 'Tracking Code', 'grevo' ),
				'description'	=> esc_attr__( 'This code will be added to HEAD element on your all pages.', 'grevo' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'custom',
				'settings'		=> 'cust_css_heading',
				'default'		=> '<div class="themesion-option-heading"><h2>' . esc_html__( 'Custom CSS Code', 'grevo' ) . '</h2> <span>' . esc_attr__( 'Custom CSS Code', 'grevo' ) . '</span></div>',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'css-code',
				'label'			=> esc_attr__( 'Custom CSS Code', 'grevo' ),
				'description'	=> esc_attr__( 'Add your custom CSS code here.', 'grevo' ),
				'default'		=> '',
			),
			array(
				'type'			=> 'textarea',
				'settings'		=> 'js-code',
				'label'			=> esc_attr__( 'Custom JS Code', 'grevo' ),
				'description'	=> esc_attr__( 'Add your custom JS code here.', 'grevo' ),
				'default'		=> '',
			),
		)
	),
);
// adding WooCommerce options
if( function_exists('is_woocommerce') ){
	$kirki_options_array2 = array();
	foreach( $kirki_options_array as $sections=>$settings ){
		$kirki_options_array2[$sections] = $settings;
		if( $sections == 'portfolio_options' ){
			$kirki_options_array2['woocommerce_options'] = array(
				'section_settings' => array(
					'title'			=> esc_attr__( 'WooCommerce Options', 'grevo' ),
					'panel'			=> 'grevo_base_options',
					'priority'		=> 160,
				),
				'section_fields' => array(
					// Heading Options
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-wc-shop',
						'label'		=> esc_html__( 'WooCommerce Shop Sidebar', 'grevo' ),
						'default'	=> 'right',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'radio-image',
						'settings'	=> 'sidebar-wc-single',
						'label'		=> esc_html__( 'WooCommerce Single Product Sidebar', 'grevo' ),
						'default'	=> 'no',
						'choices'		=> array(
							'left'		=> get_template_directory_uri() . '/includes/images/sidebar-left.png',
							'right'		=> get_template_directory_uri() . '/includes/images/sidebar-right.png',
							'no'		=> get_template_directory_uri() . '/includes/images/sidebar-no.png',
						),
					),
					array(
						'type'		=> 'text',
						'settings'	=> 'wc-title',
						'label'		=> esc_attr__( 'WooCommerce Shop Page Title', 'grevo' ),
						'description'	=> esc_attr__( 'This will appear in Titlebar on Shop page.', 'grevo' ),
						'default'	=> esc_attr('Shop'),
					),
					array(
						'type'			=> 'select',
						'settings'		=> 'wc-related-count',
						'label'			=> esc_attr__( 'How many related products will be shown?', 'grevo' ),
						'description'	=> esc_attr__( 'How many related products will be shown on single product page?', 'grevo' ),
						'default'		=> '3',
						'choices'		=> array(
							'1'		=> esc_attr__( '1 product', 'grevo' ),
							'2'		=> esc_attr__( '2 products', 'grevo' ),
							'3'		=> esc_attr__( '3 products', 'grevo' ),
							'4'		=> esc_attr__( '4 products', 'grevo' ),
						),
					),
					array(
						'type'			=> 'switch',
						'settings'		=> 'wc-show-cart-icon',
						'label'			=> esc_attr__( 'Show Cart Icon in Header?', 'grevo' ),
						'description'	=> esc_attr__( 'Show or hide cart icon in header area. The icon will appear only if WooCommerce plugin is active.', 'grevo' ),
						'default'		=> '1',
						'choices'		=> array(
							'on'		=> esc_attr__( 'Yes', 'grevo' ),
							'off'		=> esc_attr__( 'No', 'grevo' ),
						),
					),
					array(
						'type'			=> 'switch',
						'settings'		=> 'wc-show-cart-amount',
						'label'			=> esc_attr__( 'Show Amount with Cart Icon in Header?', 'grevo' ),
						'description'	=> esc_attr__( 'Show or hide cart amount with cart icon in header area. The icon will appear only if WooCommerce plugin is active.', 'grevo' ),
						'default'		=> '1',
						'choices'		=> array(
							'on'		=> esc_attr__( 'Yes', 'grevo' ),
							'off'		=> esc_attr__( 'No', 'grevo' ),
						),
						'active_callback' => array( array(
							'setting'		=> 'wc-show-cart-icon',
							'operator'		=> '==',
							'value'			=> '1',
						) ),
					),
				)
			);
		}
	} // foreach
	$kirki_options_array = $kirki_options_array2;
}