<?php
/**
 *
 * @package WordPress
 * @subpackage Grevo
 * @since 1.0
 * @version 1.0
 */
?>
<div class="thsn-header-overlay">
	<?php get_template_part( 'theme-parts/header/pre-header',	thsn_get_base_option('header-style') ); ?>
	<div class="thsn-header-height-wrapper">
		<div class="thsn-main-header-area <?php thsn_header_class(); ?> <?php thsn_header_bg_class(); ?>">
			<div class="container-full">
				<div class="d-flex justify-content-between align-items-center">
					<div class="thsn-logo-menuarea">
						<div class="site-branding thsn-logo-area">
							<div class="wrap">
								<?php echo thsn_logo(); ?><!-- Logo area -->
							</div><!-- .wrap -->
						</div><!-- .site-branding -->
						<!-- Top Navigation Menu -->
						<div class="navigation-top">
							<button id="menu-toggle" class="nav-menu-toggle">
								<i class="thsn-base-icon-menu-1"></i>
							</button>
							<div class="thsn-mobile-menu-bg"></div>
							<div class="wrap">
								<nav id="site-navigation" class="main-navigation thsn-navbar <?php thsn_nav_class(); ?>" aria-label="<?php esc_attr_e( 'Top Menu', 'grevo' ); ?>">
									<?php wp_nav_menu( array(
										'theme_location' => 'themesion-top',
										'menu_id'        => 'thsn-top-menu',
										'menu_class'     => 'menu',
									) ); ?>
								</nav><!-- #site-navigation -->
							</div><!-- .wrap -->
							<div class="thsn-right-box">
								<div class="thsn-search-cart-box">
									<?php thsn_header_search(); ?>
									<?php thsn_cart_icon(); ?>
								</div>
							</div>
						</div><!-- .navigation-top -->
					</div>
					<div class="thsn-button-box">					
						<?php thsn_header_button(); ?>
						<?php thsn_header_button_second(); ?>	
					</div>
				</div><!-- .justify-content-between -->
			</div><!-- .container -->
		</div><!-- .thsn-header-wrapper -->
	</div><!-- .thsn-header-height-wrapper -->
</div><!--thsn-header-overlay -->
<span class="thsn-social-label"></span>
<?php if( shortcode_exists('thsn-social-links') ){
	$social = do_shortcode('[thsn-social-links]');
	echo thsn_esc_kses($social);
} ?>
