<?php
$icon_html = '';
$custom_icon_enabled = get_post_meta( get_the_ID(), 'thsn-custom-icon-enabled', true ); 
if( $custom_icon_enabled=='1' ){
	$img_src = '';
	$custom_icon_url = get_post_meta( get_the_ID(), 'thsn-custom-icon', true );
	if( !empty($custom_icon_url) ){
		$img_src = wp_get_attachment_image_src($custom_icon_url, 'full');
		if( !empty($img_src[0]) ){ $custom_icon_url = $img_src[0]; }
	}
	$icon_html = '<img src="'.$custom_icon_url.'"/>';
}else{
	$icon_lib = get_post_meta( get_the_ID(), 'thsn-service-icon-library', true );
	wp_enqueue_style($icon_lib);
	$icon_class = get_post_meta( get_the_ID(), 'thsn-service-icon-'.$icon_lib, true );
	if( !empty($icon_class) ){
		$icon_html = '<i class="'.esc_attr($icon_class).'"></i>';
	}
}

// Read More text
if( !isset($more_text) ){
	$more_text = esc_attr__('More','grevo');
}
?>
<div class="themesion-post-item">
	<div class="thsn-service-img-wrapper">			  
		<?php thsn_get_featured_data( array( 'featured_img_only' => true, 'size' => 'thsn-img-770x650' ) ); ?>
	<div class="themesioni-box-overlay"></div>	
	</div>	
	<div class="themesion-box-content">
		<div class="themesion-box-content-inner">
			<h3 class="thsn-service-title"><a href="<?php the_permalink(); ?>" title="<?php echo get_the_title(); ?>"><?php echo get_the_title(); ?></a></h3> 
			<?php if( has_excerpt() ) : ?>
			<div class="thsn-service-content"><?php the_excerpt(); ?></div>
			<?php endif; ?> 
			<div class="thsn-service-btn"> 
			<a class="btn-arrow" href="<?php the_permalink(); ?>"><span><?php esc_html_e('View More', 'grevo'); ?></span></a>
			</div>
		</div>
	</div>
</div>
