<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Grevo
 * @since 1.0
 * @version 1.2
 */
// Class list
$progressbar_title = '';
$style		= thsn_get_base_option('team-single-style');
$class_list	= 'container thsn-team-single-style-'.$style;
// Team Member details
$designation	= get_post_meta( get_the_ID(), 'thsn-team-details_designation', true ); 
if( !empty($designation) ){ $designation = '<h4 class="thsn-team-designation">' . esc_attr($designation) . '</h4>'; }
$email			= get_post_meta( get_the_ID(), 'thsn-team-details_email', true ); 
if( !empty($email) ){ $email = '<li><label>'.esc_html__('Email', 'grevo').'</label> <a href="mailto:' . sanitize_email($email) . '">' . esc_attr($email) . '</a></li>'; }
$phone			= get_post_meta( get_the_ID(), 'thsn-team-details_phone', true ); 
if( !empty($phone) ){ $phone = '<li><label>'.esc_html__('Phone', 'grevo').'</label> ' . esc_attr($phone) . '</li>'; }
$sitetitle		= get_post_meta( get_the_ID(), 'thsn-team-details_sitetitle', true );
$siteurl		= get_post_meta( get_the_ID(), 'thsn-team-details_siteurl', true ); 
$site			= '';
if( !empty($siteurl) ){
	$sitetitle		= ( empty($sitetitle) ) ? $siteurl : $sitetitle ;
	$site = '<li><label>'.esc_html__('Website', 'grevo').'</label> <a href="' . esc_url($siteurl) . '">' . esc_attr($sitetitle) . '</a> </li>';
}
$fax			= get_post_meta( get_the_ID(), 'thsn-team-details_fax', true ); 
if( !empty($fax) ){ $fax = '<li><label>'.esc_html__('Fax', 'grevo').'</label> ' . esc_attr($fax) . '</li>'; }
if( function_exists('thsn_uencode') ){
	$progress_1_number		= get_post_meta( get_the_ID(), 'thsn-team-details_progress_1_number', true );
	$progress_1_label		= get_post_meta( get_the_ID(), 'thsn-team-details_progress_1_label', true );
	$progress_2_number		= get_post_meta( get_the_ID(), 'thsn-team-details_progress_2_number', true );
	$progress_2_label		= get_post_meta( get_the_ID(), 'thsn-team-details_progress_2_label', true );
	$values = '';
	if( !empty($progress_1_label) ){
		$values .= '{"label":"'.esc_attr($progress_1_label).'","value":"'.esc_attr($progress_1_number).'"}';
	}
	if( !empty($progress_2_label) ){
		$values .= ',{"label":"'.esc_attr($progress_2_label).'","value":"'.esc_attr($progress_2_number).'"}';
	}
	if( !empty($values) ){
		$values = '['.$values.']';
	}
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $class_list ); ?>>
	<div class="thsn-team-single">
		<div class="thsn-team-single-inner">
			<div class="thsn-team-single-info">
			<div class="row align-items-center">
				<div class="col-md-12 col-lg-6 thsn-left-inner">
					<div class="thsn-team-left-inner">
						<?php thsn_get_featured_data( array( 'featured_img_only' => false, 'size' => 'thsn-img-590x480' ) ); ?>
					</div>
				</div>
				<div class="col-md-12 col-lg-6 thsn-right-inner">
				 <div class="thsn-team-des">
					<div class="d-flex justify-content-between align-items-center thsn-summary-wrap">
						<div class="thsn-team-summary">
								<h2 class="thsn-team-title"><?php the_title(); ?></h2>							
								<?php echo thsn_esc_kses($designation); ?>
						</div>
						<?php echo thsn_team_social_links(); ?>
					</div>
					<?php
					// Short Description
					$short_desc = get_post_meta( get_the_ID(), 'thsn-team-details_short-description', true );
					if( !empty($short_desc) ){
						?>
						<div class="thsn-short-description">
							<?php echo do_shortcode($short_desc); ?>
						</div>
						<ul class="thsn-single-team-info">
							<?php echo thsn_esc_kses($phone); ?>
							<?php echo thsn_esc_kses($email); ?>
							<?php echo thsn_esc_kses($site); ?>
							<?php echo thsn_esc_kses($fax); ?>
						</ul>	
						<?php
					}
					?>
					<?php 
					// Download vcard
					$downloadvcard = get_post_meta( get_the_ID(), 'thsn-team-details_downloadvcard', true );
					$downloadvcard_link = get_post_meta( get_the_ID(), 'thsn-team-details_downloadvcard-link', true );
					if( !empty($downloadvcard) ){
					?>
						<div class="thsn-team-download">
							<?php if( !empty($downloadvcard_link) ) : ?><a href="<?php echo esc_url($downloadvcard_link); ?>"><?php endif; ?>
							<?php echo thsn_esc_kses($downloadvcard); ?>
							<?php if( !empty($downloadvcard_link) ) : ?></a><?php endif; ?>
						</div>
					<?php 
					} ?>
				  </div>				  
				 </div>
				</div>
				</div>
				<div class="row">
				<div class="col-md-12">
					<div class="thsn-entry-content">
						<?php
						/* translators: %s: Name of current post */
						the_content( sprintf(
							'',
							get_the_title()
						) );
						?>
					</div>
				</div>
			</div><!-- .row -->
		</div>
	</div><!-- .thsn-team-single -->
</article><!-- #post-## -->
<?php thsn_edit_link(); ?>