<?php
namespace Elementor; // Custom widgets must be defined in the Elementor namespace
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly (security measure)

/**
 * Widget Name: Projects Carousel
 */
class thsn_TimelineElement extends Widget_Base{

 	// The get_name() method is a simple one, you just need to return a widget name that will be used in the code.
	public function get_name() {
		return 'thsn_timeline_element';
	}

	// The get_title() method, which again, is a very simple one, you need to return the widget title that will be displayed as the widget label.
	public function get_title() {
		return esc_attr__( 'Grevo Timeline Element', 'grevo' );
	}

	// The get_icon() method, is an optional but recommended method, it lets you set the widget icon. you can use any of the eicon or font-awesome icons, simply return the class name as a string.
	public function get_icon() {
		return 'fas fa-th-large';
	}

	// The get_categories method, lets you set the category of the widget, return the category name as a string.
	public function get_categories() {
		return [ 'grevo_category' ];
	}

	public function __construct($data = [], $args = null) {
		parent::__construct($data, $args);
		if( isset($data['settings']["view-type"]) && !empty($data['settings']["view-type"]) && $data['settings']["view-type"]=='carousel' ){
			wp_enqueue_script( 'owl-carousel' );
			wp_enqueue_style( 'owl-carousel' );
			wp_enqueue_style( 'owl-carousel-theme' );
		}
	}

	protected function register_controls() {

		// Heading and Subheading
		$this->start_controls_section(
			'heading_section',
			[
				'label' => esc_attr__( 'Heading and Subheading', 'grevo' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_attr__( 'Title', 'grevo' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'Welcome to our site', 'grevo' ),
				'placeholder' => esc_attr__( 'Enter your title', 'grevo' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'title_link',
			[
				'label' => esc_attr__( 'Title Link', 'grevo' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$this->add_control(
			'subtitle',
			[
				'label' => esc_attr__( 'Subtitle', 'grevo' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => esc_attr__( 'This is Subtitle', 'grevo' ),
				'placeholder' => esc_attr__( 'Enter your subtitle', 'grevo' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'subtitle_link',
			[
				'label' => esc_attr__( 'Subtitle Link', 'grevo' ),
				'type' => Controls_Manager::URL,
				'label_block' => true,
			]
		);
		$this->add_control(
			'desc',
			[
				'label' => esc_attr__( 'Description', 'grevo' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_attr__( 'Type your description here', 'grevo' ),
			]
		);
		$this->add_control(
			'reverse_title',
			[
				'label' => esc_attr__( 'Reverse Title', 'grevo' ),
				'description' => esc_attr__( 'Show sub-title before title', 'grevo' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_attr__( 'Yes', 'grevo' ),
				'label_off' => esc_attr__( 'No', 'grevo' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label' => esc_attr__( 'Alignment', 'grevo' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => esc_attr__( 'Left', 'grevo' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_attr__( 'Center', 'grevo' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_attr__( 'Right', 'grevo' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .thsn-ele-header-area' => 'text-align: {{VALUE}};',
				],
				'dynamic' => [
					'active' => true,
				],
				'default' => 'left',
			]
		);

		// Tags
		$this->add_control(
			'tag_options',
			[
				'label'			=> esc_attr__( 'Tags for SEO', 'grevo' ),
				'type'			=> Controls_Manager::HEADING,
				'separator'		=> 'before',
			]
		);
		$this->add_control(
			'title_tag',
			[
				'label' => esc_attr__( 'Title Tag', 'grevo' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h2' ),
			]
		);
		$this->add_control(
			'subtitle_tag',
			[
				'label' => esc_attr__( 'SubTitle Tag', 'grevo' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'h1'	=> esc_attr( 'H1' ),
					'h2'	=> esc_attr( 'H2' ),
					'h3'	=> esc_attr( 'H3' ),
					'h4'	=> esc_attr( 'H4' ),
					'h5'	=> esc_attr( 'H5' ),
					'h6'	=> esc_attr( 'H6' ),
					'div'	=> esc_attr( 'DIV' ),
				],
				'default' => esc_attr( 'h4' ),
			]
		);
		$this->end_controls_section();

		//Content
		$this->start_controls_section(
			'data_section',
			[
				'label' => esc_attr__( 'Content Options', 'grevo' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'grevo' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'small_text',
			[
				'label' => __( 'Small Text', 'grevo' ),
				'type' => Controls_Manager::TEXT,
				'description' => __( 'Small text like year.', 'grevo' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'grevo' ),
				'type' => Controls_Manager::TEXT,
				'description' => __( 'Title Text.', 'grevo' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'desc_text',
			[
				'label' => __( 'Description', 'grevo' ),
				'type' => Controls_Manager::TEXTAREA,
				'description' => __( 'Description Text.', 'grevo' ),
				'show_label' => true,
			]
		);
        $this->add_control(
			'values',
			[
				'label'			=> esc_attr__( 'Values', 'grevo' ),
				'description'	=> esc_attr__( 'Enter values for graph - value, title and color.', 'grevo' ),
				'type'			=> Controls_Manager::REPEATER,
				'fields'		=> $repeater->get_controls(),
				'default'		=> [
					[
						'image'			=> get_template_directory_uri() . '/images/placeholder.png',
						'small_text'	=> esc_attr__( '2010', 'grevo' ),
						'title_text'	=> esc_attr__( 'Our new branch', 'grevo' ),
						'desc_text'		=> esc_attr__( 'Our 1st branch in USA', 'grevo' ),
					],
					[
						'image'			=> get_template_directory_uri() . '/images/placeholder.png',
						'small_text'	=> esc_attr__( '2012', 'grevo' ),
						'title_text'	=> esc_attr__( 'Our new branch', 'grevo' ),
						'desc_text'		=> esc_attr__( 'Our 5th branch in USA', 'grevo' ),
					],
					[
						'image'			=> get_template_directory_uri() . '/images/placeholder.png',
						'small_text'	=> esc_attr__( '2014', 'grevo' ),
						'title_text'	=> esc_attr__( 'Our new branch', 'grevo' ),
						'desc_text'		=> esc_attr__( 'Our 7th branch in USA', 'grevo' ),
					],
				],
				'title_field' => '{{{ small_text }}}',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

		$settings	= $this->get_settings_for_display();
		extract($settings);
		?>

		<div class="thsn-timeline">
			<div class="thsn-ele-header-area">
				<?php thsn_heading_subheading($settings, true); ?>
			</div>
			<div class="thsn-first-timeline"></div>
			<div class="thsn-timeline-post-items">
				<?php if( !empty($settings['values']) && count($settings['values'])>0 ) {
					foreach($settings['values'] as $value){
						$small_text	= ( !empty($value['small_text']) ) ? $value['small_text'] : '' ;
						$title_text	= ( !empty($value['title_text']) ) ? $value['title_text'] : '' ;
						$desc_text	= ( !empty($value['desc_text']) ) ? $value['desc_text'] : '' ;
						$image		= ( !empty($value['image']['url']) ) ? '<img src="'.esc_url($value['image']['url']).'" alt="'.esc_attr($title_text).'" />' : '' ;
						?>

						<div class="thsn-timeline-inner">
							<div class=" col-sm-12 thsn-ourhistory-type2">
								<div class="row thsn-ourhistory-row">
									<div class="col-md-6 col-sm-12 col-xs-6 thsn-ourhistory-right">								
										<span class="label"><?php echo esc_html($small_text); ?></span>
										<div class="content">
											<h4><?php echo esc_html($title_text); ?></h4>
											<div class="simple-text">
												<p><?php echo thsn_esc_kses($desc_text); ?></p>
											</div>
											<!-- <?php echo thsn_esc_kses($image); ?> -->
										</div>
									</div>
									<div class="col-md-6 thsn-ourhistory-left">
										<span class="thsn-timeline-image"><?php echo thsn_esc_kses($image); ?></span>
									</div>
								</div>
							</div>
						</div>

					<?php
					}
				}
				?>
			</div>
			<div class="thsn-last-timeline"></div>
		</div>
	    <?php
	}

	protected function content_template() {}

	protected function select_category() {
		$category = get_terms( array( 'taxonomy' => 'thsn-timeline-category', 'hide_empty' => false ) );
	  	$cat = array();
	  	foreach( $category as $item ) {
			$cat_count = get_category( $item );
	     	if( $item ) {
	        	$cat[$item->slug] = $item->name . ' ('.$cat_count->count.')';
	     	}
	  	}
	  	return $cat;
	}
}
// After the Schedule class is defined, I must register the new widget class with Elementor:
Plugin::instance()->widgets_manager->register( new thsn_TimelineElement() );