<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Grevo
 * @since 1.0
 * @version 1.2
 */
// Class list
$style			= thsn_get_base_option('portfolio-single-style');
$single_style	= get_post_meta( get_the_ID(), 'thsn-portfolio-single-view', true );
if( !empty($single_style) ){ $style = $single_style; }
$class_list		= 'thsn-portfolio-single-style-'.$style;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( $class_list ); ?>>
	<div class="thsn-portfolio-single">
		<div class="thsn-single-project-content-wrapper">
			<div class="row">
				<div class="col-md-12">	
					<?php thsn_get_featured_data( array( 'featured_img_only' => false, 'size' => 'thsn-img-1170x540' ) ); ?> 
				</div> 
		    </div>
			<div class="row">
				<div class="col-md-12">	
					<div  class="thsn-single-project-details-list">
						<h4><?php esc_html_e('Project info', 'grevo'); ?></h4>
					<?php
						// Short Description
						$short_desc = get_post_meta( get_the_ID(), 'thsn-short-description', true );
						if( !empty($short_desc) ){
							?>
							<div class="thsn-short-description">
								<?php echo do_shortcode($short_desc); ?>
							</div> 
							<?php
						}
						?> 
							<?php thsn_portfolio_details_list(); ?>	
						</div>
					</div>
				</div> 
		    </div>

		<div class="row">
			<div class="col-md-12">				
				<div class="thsn-entry-content">
					<?php
					/* translators: %s: Name of current post */
					the_content( sprintf(
						'',
						get_the_title()
					) );
					?>
				</div><!-- .entry-content -->	
			</div>

		</div>
		<?php
		// Prev Next Post Link
		$cpt_name = thsn_get_base_option('portfolio-cpt-singular-title');
		$next_post = get_next_post();
		$previous_post = get_previous_post();
		$prevThumbnail = isset( $previous_post->ID ) ? get_the_post_thumbnail($previous_post->ID,'thumbnail') : '';
		$nextThumbnail = isset( $next_post->ID ) ? get_the_post_thumbnail($next_post->ID,'thumbnail') : '';
		the_post_navigation( array(
			'prev_text' => thsn_esc_kses( '<span class="thsn-portfolio-nav-thumbnail">' . $prevThumbnail .'<span class="thsn-portfolio-nav-icon"><i class=" thsn-base-icon-left-small"></i></span> </span> <span class="thsn-portfolio-nav-wrapper"><span class="thsn-portfolio-nav-head">' . sprintf( esc_attr__('Previous', 'grevo') , $cpt_name ) . '</span>' ) . thsn_esc_kses( '<span class="thsn-portfolio-nav nav-title">%title</span> </span>' ),
			'next_text' => thsn_esc_kses( '<span class="thsn-portfolio-nav-wrapper"><span class="thsn-portfolio-nav-head">' . sprintf( esc_attr__('Next', 'grevo') , $cpt_name ) . '</span>' ) . thsn_esc_kses( '<span class="thsn-portfolio-nav nav-title">%title</span> </span> <span class="thsn-portfolio-nav-thumbnail"> <span class="thsn-portfolio-nav-icon"><i class=" thsn-base-icon-right-small"></i></span>' . $nextThumbnail .'</span>' ),
		) );
		?>
	</div>
</article><!-- #post-## -->
<?php thsn_related_portfolio(); ?>
<?php thsn_edit_link(); ?>